package com.biz.crm.sfa.business.template.action.ordinary.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import com.biz.crm.sfa.business.template.action.ordinary.sdk.enums.ActionOrdinaryScopeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 普通活动范围vo
 *
 * @author ning.zhang
 * @date 2022/7/28
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionOrdinaryScopeVo", description = "普通活动范围vo")
public class ActionOrdinaryScopeVo extends TenantOpVo {

  private static final long serialVersionUID = 6222067486444994764L;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  private String scopeName;

  /**
   * 范围类型(org:组织范围,channel:渠道范围,client:客户范围)
   *
   * @see ActionOrdinaryScopeType
   */
  @ApiModelProperty("范围类型(org:组织范围,channel:渠道范围,client:客户范围)")
  private String scopeType;
}
