package com.biz.crm.sfa.business.template.action.tpm.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * PM活动: ActionTpmExecute: TPM活动执行信息
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionTpm/actionTpmExecute")
@Api(tags = "TPM活动: ActionTpmExecute: TPM活动执行信息")
public class ActionTpmExecuteController {

  @Autowired
  private ActionTpmExecuteService actionTpmExecuteService;

  /**
   * 活动执行分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 活动执行分页数据
   */
  @ApiOperation(value = "活动执行分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<ActionTpmExecuteEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                               @ApiParam(name = "ActionTpmExecutePageDto", value = "分页Dto") ActionTpmExecutePageDto dto) {
    try {
      return Result.ok(this.actionTpmExecuteService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
