package com.biz.crm.sfa.business.template.action.tpm.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmExecuteVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * PM活动: ActionTpmExecuteVo: TPM活动执行信息
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionTpm/actionTpmExecute")
@Api(tags = "TPM活动: ActionTpmExecuteVo: TPM活动执行信息")
public class ActionTpmExecuteVoController {

  @Autowired
  private ActionTpmExecuteVoService actionTpmExecuteVoService;

  /**
   * 通过活动执行ID获取活动执行信息
   *
   * @param id 活动执行ID
   * @return 活动执行信息
   */
  @ApiOperation(value = "通过活动执行ID获取活动执行信息")
  @GetMapping("/findById")
  public Result<ActionTpmExecuteVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.actionTpmExecuteVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
