package com.biz.crm.sfa.business.template.action.tpm.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmModel;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmModelService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecuteDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM活动表单: ActionTpmModel: TPM活动model
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionTpm/actionTpmModel")
@Api(tags = "TPM活动表单: ActionTpmModel: TPM活动model")
public class ActionTpmModelController {

  @Autowired
  private ActionTpmModelService actionTpmModelService;

  /**
   * 通过信息查询dto查询数据
   *
   * @param dto 参数dto
   * @return 查询对象包含关联信息
   */
  @ApiOperation(value = "通过条件信息查询数据")
  @GetMapping("findByActionTpmExecuteDto")
  public Result<ActionTpmModel> findByActionTpmExecuteDto(@ApiParam(name = "dto", value = "TPM活动执行查询dto") ActionTpmExecuteDto dto) {
    try {
      return Result.ok(this.actionTpmModelService.findByActionTpmExecuteDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
