package com.biz.crm.sfa.business.template.action.tpm.local.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * TPM活动执行表
 *
 * @author ning.zhang
 * @date 2022/6/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionTpmExecuteEntity", description = "TPM活动执行表")
@Entity
@TableName("sfa_action_tpm_execute")
@Table(name = "sfa_action_tpm_execute", indexes = {
    @Index(name = "sfa_action_tpm_execute_index1", columnList = "tenant_code,execute_code", unique = true),
    @Index(name = "sfa_action_tpm_execute_index2", columnList = "parent_code"),
    @Index(name = "sfa_action_tpm_execute_index3", columnList = "dynamic_key"),
    @Index(name = "sfa_action_tpm_execute_index4", columnList = "terminal_code"),
    @Index(name = "sfa_action_tpm_execute_index5", columnList = "action_code"),
    @Index(name = "sfa_action_tpm_execute_index6", columnList = "action_detail_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_tpm_execute", comment = "TPM活动执行表")
public class ActionTpmExecuteEntity extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -6250510837246894643L;

  /**
   * TPM活动编码
   */
  @ApiModelProperty("TPM活动编码")
  @Column(name = "action_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT 'TPM活动编码'")
  private String actionCode;

  /**
   * TPM活动名称
   */
  @ApiModelProperty("TPM活动名称")
  @Column(name = "action_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT 'TPM活动名称'")
  private String actionName;

  /**
   * TPM活动开始时间
   */
  @ApiModelProperty("TPM活动开始时间")
  @Column(name = "action_start_date", columnDefinition = "datetime COMMENT 'TPM活动开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * TPM活动结束时间
   */
  @ApiModelProperty("TPM活动结束时间")
  @Column(name = "action_end_date", columnDefinition = "datetime COMMENT 'TPM活动结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * TPM活动明细编码
   */
  @ApiModelProperty("TPM活动明细编码")
  @Column(name = "action_detail_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT 'TPM活动明细编码'")
  private String actionDetailCode;

  /**
   * 活动执行编码
   */
  @ApiModelProperty("活动执行编码")
  @Column(name = "execute_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '活动执行编码'")
  private String executeCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @Column(name = "terminal_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @Column(name = "terminal_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '终端名称'")
  private String terminalName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  @Column(name = "terminal_type", length = 64, columnDefinition = "varchar(64) COMMENT '终端类型'")
  private String terminalType;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  @Column(name = "post_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人职位编码'")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  @Column(name = "post_name", columnDefinition = "varchar(255) COMMENT '提交人职位名称'")
  private String postName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人组织编码")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人组织编码'")
  private String orgCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人组织名称")
  @Column(name = "org_name", columnDefinition = "varchar(255) COMMENT '提交人组织名称'")
  private String orgName;

  /**
   * 陈列协议
   */
  @ApiModelProperty("陈列协议")
  @Transient
  @TableField(exist = false)
  private List<ActionTpmProtocolEntity> displayProtocols;

  /**
   * 关联上级模块数据映射(key:上层业务key,value:上层业务数据)
   */
  @ApiModelProperty("关联上级模块数据映射(key:上层业务key,value:上层业务数据)")
  @Transient
  @TableField(exist = false)
  private Map<String,List<JSONObject>> relationMap;
}
