package com.biz.crm.sfa.business.template.action.tpm.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * TPM活动执行陈列协议签署商品表
 *
 * @author ning.zhang
 * @date 2022/6/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionTpmProtocolProductEntity", description = "TPM活动执行陈列协议签署商品表")
@Entity
@TableName("sfa_action_tpm_protocol_product")
@Table(name = "sfa_action_tpm_protocol_product", indexes = {
    @Index(name = "sfa_action_tpm_protocol_product_index1", columnList = "protocol_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_tpm_protocol_product", comment = "TPM活动执行陈列协议签署商品表")
public class ActionTpmProtocolProductEntity extends UuidEntity {

  private static final long serialVersionUID = -483517093793519516L;

  /**
   * TPM活动执行协议ID
   */
  @ApiModelProperty("TPM活动执行协议ID")
  @Column(name = "protocol_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT 'TPM活动执行协议ID'")
  private String protocolId;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  @Column(name = "product_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品名称'")
  private String productName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  @Column(name = "product_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '商品编码'")
  private String productCode;
}
