package com.biz.crm.sfa.business.template.action.tpm.local.model;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesFieldsCollectTemplateFeginVo;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

/**
 * TPM活动执行表单model
 *
 * @author ning.zhang
 * @date 2022/6/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionTpmModel", description = "TPM活动执行表单model")
public class ActionTpmModel extends AbstractDynamicTemplateModel {

  private static final long serialVersionUID = -7236389012940038885L;

  /**
   * 是否为拜访步骤执行
   */
  @ApiModelProperty("是否为拜访步骤执行")
  private Boolean stepFormOrNot;

  /**
   * 基本信息
   */
  @ApiModelProperty("基本信息")
  private ActionTpmBasicModel basicInfo;

  /**
   * 陈列协议
   */
  @ApiModelProperty("陈列协议")
  private List<ActionTpmProtocolModel> displayProtocols;

  /**
   * 关联上级模块数据映射(key:上层业务key,value:上层业务数据)
   */
  @ApiModelProperty("关联上级模块数据映射(key:上层业务key,value:上层业务数据)")
  private Map<String,List<JSONObject>> relationMap;

  /**
   * 活动图片采集要求数据
   */
  @ApiModelProperty("活动图片采集要求数据")
  private List<ActivitiesDetailCollectVo> activitiesDetailCollects;

  /**
   * 图片采集要求
   */
  @ApiModelProperty("图片采集要求")
  private List<ApprovalCollectVo> photoRequires;

  /**
   * 活动字段采集模板数据(同活动 不同批次)
   */
  @ApiModelProperty("活动字段采集模板数据(同活动 不同批次)")
  private List<ActivitiesFieldsCollectTemplateFeginVo> fieldsCollectTemplates;

  /**
   * 活动字段采集模板结构
   */
  @ApiModelProperty("活动字段采集模板结构")
  private JSONObject fieldsCollectTemplateStruct;
}
