package com.biz.crm.sfa.business.template.action.tpm.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import org.springframework.data.domain.Pageable;

/**
 * TPM活动执行表服务接口
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:28
 */
public interface ActionTpmExecuteService {

  /**
   * 新增数据
   *
   * @param entity 实体对象
   * @return 新增结果
   */
  ActionTpmExecuteEntity create(ActionTpmExecuteEntity entity);

  /**
   * 活动执行分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionTpmExecuteEntity> 活动执行分页信息
   */
  Page<ActionTpmExecuteEntity> findByConditions(Pageable pageable, ActionTpmExecutePageDto dto);
}
