package com.biz.crm.sfa.business.template.action.tpm.local.strategy;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmBasicModel;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmModel;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.register.ActionTpmExecuteRegister;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailCollectDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailRemoteDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailSerialDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 专门为具体的TPM活动执行业务模型服务的操作策略
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@Component
@Slf4j
public class DynamicFormOperationStrategyForActionTpmModel implements DynamicFormOperationStrategy<ActionTpmModel> {

  @Autowired
  private StepFormModuleRegister stepFormModuleRegister;
  @Autowired
  private ActionTpmExecuteService actionTpmExecuteService;
  @Autowired(required = false)
  private List<ActionTpmExecuteRegister> registers;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ActivitiesDetailService activitiesDetailService;

  @Override
  public int getOrder() {
    return 10;
  }

  @Override
  public String dynamicFormCode() {
    return StringUtils.uncapitalize(this.getClass().getSimpleName());
  }

  @Override
  public String dynamicFormName() {
    return "TPM活动执行";
  }

  @Override
  public Class<ActionTpmModel> dynamicFormClass() {
    return ActionTpmModel.class;
  }

  @Override
  public String moduleCode() {
    return this.stepFormModuleRegister.moduleCode();
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    log.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormCreate(ActionTpmModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    //非步骤执行清空步骤执行的参数,以便执行信息创建方法跳过重复验证
    if (!Boolean.TRUE.equals(dynamicForm.getStepFormOrNot())) {
      dynamicForm.setParentCode(null);
      dynamicForm.setDynamicKey(null);
    }
    ActionTpmExecuteEntity actionTpmExecuteEntity = this.nebulaToolkitService.copyObjectByBlankList(dynamicForm, ActionTpmExecuteEntity.class, HashSet.class, ArrayList.class);
    ActionTpmBasicModel basicInfo = dynamicForm.getBasicInfo();
    Validate.notNull(basicInfo, "新增数据时, 基本信息不能为空!");
    actionTpmExecuteEntity.setTerminalCode(basicInfo.getTerminalCode());
    actionTpmExecuteEntity.setTerminalName(basicInfo.getTerminalName());
    actionTpmExecuteEntity.setActionCode(basicInfo.getActionCode());
    actionTpmExecuteEntity.setActionDetailCode(basicInfo.getActionDetailCode());
    actionTpmExecuteEntity.setActionName(basicInfo.getActionName());
    ActionTpmExecuteEntity executeEntity = this.actionTpmExecuteService.create(actionTpmExecuteEntity);
    ActivitiesDetailRemoteDto remoteDto = new ActivitiesDetailRemoteDto();
    remoteDto.setActivitiesDetailCode(executeEntity.getActionDetailCode());
    remoteDto.setBtNo(executeEntity.getExecuteCode());
    remoteDto.setActivitiesDetailSerials(this.buildActivitiesDetailSerial(executeEntity));
    if (!CollectionUtils.isEmpty(dynamicForm.getFieldsCollectTemplates())) {
      remoteDto.setFieldsCollectTemplate(JsonUtils.toJSONObject(dynamicForm.getFieldsCollectTemplates().get(0)));
    }
    if (!CollectionUtils.isEmpty(dynamicForm.getActivitiesDetailCollects())) {
      remoteDto.setActivitiesDetailCollects((List<ActivitiesDetailCollectDto>)this.nebulaToolkitService.copyCollectionByBlankList(dynamicForm.getActivitiesDetailCollects()
          , ActivitiesDetailCollectVo.class, ActivitiesDetailCollectDto.class, HashSet.class, ArrayList.class));
    }
    this.activitiesDetailService.createRemote(remoteDto);
  }

  @Override
  public void onDynamicFormModify(ActionTpmModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
    throw new IllegalArgumentException("不支持修改操作");
  }

  @Override
  public ActionTpmModel findByParentCode(String dynamicKey, String parentCode) {
    //由于详情页面需要对接TPM,查询条件需要包含TPM中相关的字段,所有不提供通用的详情查询接口
    return null;
  }

  /**
   * 封装TPM系统活动明细流水
   * @param executeEntity 活动执行实体
   * @return PM系统活动明细流水
   */
  private List<ActivitiesDetailSerialDto> buildActivitiesDetailSerial(ActionTpmExecuteEntity executeEntity) {
    //封装活动明细流水信息以供TPM处理资金使用信息
    List<ActivitiesDetailSerialVo> voList = Lists.newArrayList();
    if (!CollectionUtils.isEmpty(registers)) {
      ActionTpmExecuteVo vo = this.nebulaToolkitService.copyObjectByBlankList(executeEntity
          , ActionTpmExecuteVo.class, HashSet.class, ArrayList.class);
      registers.forEach(register -> register.onCreate(vo));
      if (!CollectionUtils.isEmpty(vo.getActivitiesDetailSerials())) {
        voList.addAll(vo.getActivitiesDetailSerials());
      }
    }
    if (!CollectionUtils.isEmpty(executeEntity.getDisplayProtocols())) {
      voList.addAll(executeEntity.getDisplayProtocols().stream().map(entity -> {
        ActivitiesDetailSerialVo serialVo = new ActivitiesDetailSerialVo();
        serialVo.setActivitiesCode(executeEntity.getActionCode());
        serialVo.setActivitiesDetailCode(executeEntity.getActionDetailCode());
        serialVo.setActivitiesName(executeEntity.getActionName());
        serialVo.setBtNo(executeEntity.getExecuteCode());
        serialVo.setSerialNo(entity.getProtocolCode());
        serialVo.setSerialPrice(entity.getTotalRewardAmount());
        serialVo.setSerialTime(entity.getCreateTime());
        serialVo.setCreateTime(entity.getCreateTime());
        serialVo.setTerminalCode(executeEntity.getTerminalCode());
        serialVo.setTerminalName(executeEntity.getTerminalName());
        serialVo.setType(2);
        return serialVo;
      }).collect(Collectors.toList()));
    }
    return CollectionUtils.isEmpty(voList) ? null : (List<ActivitiesDetailSerialDto>)this.nebulaToolkitService.copyCollectionByBlankList(voList
        , ActivitiesDetailSerialVo.class, ActivitiesDetailSerialDto.class, HashSet.class, ArrayList.class);
  }
}
