package com.biz.crm.sfa.business.template.action.tpm.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * TPM活动执行表单模板操作策略实现类
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@Component
public class DynamicTemplateOperationStrategyForActionTpmModel implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForActionTpmModel dynamicFormOperationStrategyForActionTpmModel;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForActionTpmModel.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    ActionTpmModel actionTpmModel = JsonUtils.json2Obj(jsonObject.toJSONString(), ActionTpmModel.class);
    this.dynamicFormOperationStrategyForActionTpmModel.onDynamicFormCreate(actionTpmModel, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    ActionTpmModel actionTpmModel = JsonUtils.json2Obj(jsonObject.toJSONString(), ActionTpmModel.class);
    this.dynamicFormOperationStrategyForActionTpmModel.onDynamicFormModify(actionTpmModel, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForActionTpmModel.findByParentCode(dynamicKey, parentCode);
  }
}
