/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmBasicModel;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmModel;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmProtocolModel;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmModelService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecuteDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.register.ActionTpmExecuteRegister;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionTpmModelServiceImpl
implements ActionTpmModelService {
    private static final Logger log = LoggerFactory.getLogger(ActionTpmModelServiceImpl.class);
    @Autowired
    private ActionTpmExecuteRepository actionTpmExecuteRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<ActionTpmExecuteRegister> registers;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;

    @Override
    public ActionTpmModel findByActionTpmExecuteDto(ActionTpmExecuteDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getActionCode(), dto.getActionDetailCode(), dto.getTerminalCode()})) {
            return null;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<ActionTpmExecuteEntity> entities = this.actionTpmExecuteRepository.findByActionTpmExecuteDto(dto);
        ActionTpmModel actionTpmModel = new ActionTpmModel();
        actionTpmModel.setParentCode(dto.getParentCode());
        actionTpmModel.setDynamicKey(dto.getDynamicKey());
        actionTpmModel.setDisplayProtocols(this.buildProtocolInfo(entities));
        actionTpmModel.setRelationMap(this.buildRelationMap(entities));
        this.buildActionDetails(dto, actionTpmModel, entities);
        return actionTpmModel;
    }

    private void buildActionDetails(ActionTpmExecuteDto dto, ActionTpmModel actionTpmModel, List<ActionTpmExecuteEntity> entities) {
        ActionTpmBasicModel basicModel = new ActionTpmBasicModel();
        basicModel.setTerminalCode(dto.getTerminalCode());
        basicModel.setTerminalName(dto.getTerminalName());
        ActivitiesDetailVo detailVo = this.activitiesDetailService.findDetailByActivitiesDetailCode(dto.getActionDetailCode());
        if (Objects.isNull(detailVo)) {
            return;
        }
        ActivitiesVo activitiesVo = (ActivitiesVo)ObjectUtils.defaultIfNull((Object)detailVo.getActivities(), (Object)new ActivitiesVo());
        CostTypeDetailVo costTypeDetailVo = (CostTypeDetailVo)ObjectUtils.defaultIfNull((Object)detailVo.getCostTypeDetailVo(), (Object)new CostTypeDetailVo());
        basicModel.setActionCode(detailVo.getActivitiesCode());
        basicModel.setActionDetailCode(detailVo.getActivitiesDetailCode());
        basicModel.setActionDescribe(activitiesVo.getRemark());
        basicModel.setActionEndTime(activitiesVo.getEndTime());
        basicModel.setActionName(detailVo.getActivitiesName());
        basicModel.setActionStartTime(activitiesVo.getBeginTime());
        basicModel.setPayType(detailVo.getPayType());
        basicModel.setPayTypeName(detailVo.getPayTypeName());
        basicModel.setStoreUsedAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getTerminalAmount(), (Object)BigDecimal.ZERO));
        basicModel.setTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getApplyAmount(), (Object)BigDecimal.ZERO));
        basicModel.setUsedAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getTotalAmount(), (Object)BigDecimal.ZERO));
        basicModel.setIsCollectData(costTypeDetailVo.getIsCollectData());
        basicModel.setIsCollectDistributionOrder(costTypeDetailVo.getIsCollectDistributionOrder());
        basicModel.setIsSignDisplayAgreement(costTypeDetailVo.getIsSignDisplayAgreement());
        actionTpmModel.setBasicInfo(basicModel);
        actionTpmModel.setActivitiesDetailCollects((List)ObjectUtils.defaultIfNull((Object)detailVo.getActivitiesDetailCollects(), (Object)Lists.newArrayList()));
        actionTpmModel.setFieldsCollectTemplates((List)ObjectUtils.defaultIfNull((Object)detailVo.getFieldsCollectTemplates(), (Object)Lists.newArrayList()));
        actionTpmModel.setFieldsCollectTemplateStruct(detailVo.getFieldsCollectTemplateStruct());
        actionTpmModel.setPhotoRequires((List)ObjectUtils.defaultIfNull((Object)detailVo.getPhotoRequires(), (Object)Lists.newArrayList()));
        ArrayList executeCodes = !CollectionUtils.isEmpty(entities) ? entities.stream().map(ActionTpmExecuteEntity::getExecuteCode).collect(Collectors.toList()) : Lists.newArrayList();
        actionTpmModel.setFieldsCollectTemplates(actionTpmModel.getFieldsCollectTemplates().stream().filter(o -> executeCodes.contains(o.getBtNo())).collect(Collectors.toList()));
        actionTpmModel.setActivitiesDetailCollects(actionTpmModel.getActivitiesDetailCollects().stream().filter(o -> executeCodes.contains(o.getBtNo())).collect(Collectors.toList()));
    }

    private List<ActionTpmProtocolModel> buildProtocolInfo(List<ActionTpmExecuteEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List<String> executeIds = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        List<ActionTpmExecuteEntity> detailEntities = this.actionTpmExecuteRepository.findByIds(executeIds);
        ArrayList list = Lists.newArrayList();
        detailEntities.forEach(entity -> {
            if (!CollectionUtils.isEmpty(entity.getDisplayProtocols())) {
                list.addAll(this.nebulaToolkitService.copyCollectionByBlankList(entity.getDisplayProtocols(), ActionTpmProtocolEntity.class, ActionTpmProtocolModel.class, HashSet.class, ArrayList.class, new String[0]));
            }
        });
        return list;
    }

    private Map<String, List<JSONObject>> buildRelationMap(List<ActionTpmExecuteEntity> entities) {
        HashMap relationMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(entities)) {
            return relationMap;
        }
        Set executeCodes = entities.stream().map(ActionTpmExecuteEntity::getExecuteCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(this.registers)) {
            return relationMap;
        }
        this.registers.forEach(register -> {
            Map map = register.onRequestByExecuteCodes(executeCodes);
            if (Objects.isNull(map)) {
                return;
            }
            relationMap.put(register.relationKey(), map.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        });
        return relationMap;
    }
}

