/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.strategy;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.sfa.business.step.sdk.register.StepFormModuleRegister;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmBasicModel;
import com.biz.crm.sfa.business.template.action.tpm.local.model.ActionTpmModel;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.register.ActionTpmExecuteRegister;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailCollectDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailRemoteDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailSerialDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicFormOperationStrategyForActionTpmModel
implements DynamicFormOperationStrategy<ActionTpmModel> {
    private static final Logger log = LoggerFactory.getLogger(DynamicFormOperationStrategyForActionTpmModel.class);
    @Autowired
    private StepFormModuleRegister stepFormModuleRegister;
    @Autowired
    private ActionTpmExecuteService actionTpmExecuteService;
    @Autowired(required=false)
    private List<ActionTpmExecuteRegister> registers;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivitiesDetailService activitiesDetailService;

    public int getOrder() {
        return 10;
    }

    public String dynamicFormCode() {
        return StringUtils.uncapitalize((String)this.getClass().getSimpleName());
    }

    public String dynamicFormName() {
        return "TPM\u6d3b\u52a8\u6267\u884c";
    }

    public Class<ActionTpmModel> dynamicFormClass() {
        return ActionTpmModel.class;
    }

    public String moduleCode() {
        return this.stepFormModuleRegister.moduleCode();
    }

    public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
        log.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
    }

    public void onDynamicFormCreate(ActionTpmModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
        if (!Boolean.TRUE.equals(dynamicForm.getStepFormOrNot())) {
            dynamicForm.setParentCode(null);
            dynamicForm.setDynamicKey(null);
        }
        ActionTpmExecuteEntity actionTpmExecuteEntity = (ActionTpmExecuteEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dynamicForm, ActionTpmExecuteEntity.class, HashSet.class, ArrayList.class, new String[0]));
        ActionTpmBasicModel basicInfo = dynamicForm.getBasicInfo();
        Validate.notNull((Object)basicInfo, (String)"\u65b0\u589e\u6570\u636e\u65f6, \u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        actionTpmExecuteEntity.setTerminalCode(basicInfo.getTerminalCode());
        actionTpmExecuteEntity.setTerminalName(basicInfo.getTerminalName());
        actionTpmExecuteEntity.setActionCode(basicInfo.getActionCode());
        actionTpmExecuteEntity.setActionDetailCode(basicInfo.getActionDetailCode());
        actionTpmExecuteEntity.setActionName(basicInfo.getActionName());
        ActionTpmExecuteEntity executeEntity = this.actionTpmExecuteService.create(actionTpmExecuteEntity);
        ActivitiesDetailRemoteDto remoteDto = new ActivitiesDetailRemoteDto();
        remoteDto.setActivitiesDetailCode(executeEntity.getActionDetailCode());
        remoteDto.setBtNo(executeEntity.getExecuteCode());
        remoteDto.setActivitiesDetailSerials(this.buildActivitiesDetailSerial(executeEntity));
        if (!CollectionUtils.isEmpty(dynamicForm.getFieldsCollectTemplates())) {
            remoteDto.setFieldsCollectTemplate(JsonUtils.toJSONObject((Object)dynamicForm.getFieldsCollectTemplates().get(0)));
        }
        if (!CollectionUtils.isEmpty(dynamicForm.getActivitiesDetailCollects())) {
            remoteDto.setActivitiesDetailCollects((List)this.nebulaToolkitService.copyCollectionByBlankList(dynamicForm.getActivitiesDetailCollects(), ActivitiesDetailCollectVo.class, ActivitiesDetailCollectDto.class, HashSet.class, ArrayList.class, new String[0]));
        }
        this.activitiesDetailService.createRemote(remoteDto);
    }

    public void onDynamicFormModify(ActionTpmModel dynamicForm, String dynamicKey, String parentCode, Object parent) {
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c");
    }

    public ActionTpmModel findByParentCode(String dynamicKey, String parentCode) {
        return null;
    }

    private List<ActivitiesDetailSerialDto> buildActivitiesDetailSerial(ActionTpmExecuteEntity executeEntity) {
        ArrayList voList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(this.registers)) {
            ActionTpmExecuteVo vo = (ActionTpmExecuteVo)this.nebulaToolkitService.copyObjectByBlankList((Object)executeEntity, ActionTpmExecuteVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.registers.forEach(register -> register.onCreate(vo));
            if (!CollectionUtils.isEmpty((Collection)vo.getActivitiesDetailSerials())) {
                voList.addAll(vo.getActivitiesDetailSerials());
            }
        }
        if (!CollectionUtils.isEmpty(executeEntity.getDisplayProtocols())) {
            voList.addAll(executeEntity.getDisplayProtocols().stream().map(entity -> {
                ActivitiesDetailSerialVo serialVo = new ActivitiesDetailSerialVo();
                serialVo.setActivitiesCode(executeEntity.getActionCode());
                serialVo.setActivitiesDetailCode(executeEntity.getActionDetailCode());
                serialVo.setActivitiesName(executeEntity.getActionName());
                serialVo.setBtNo(executeEntity.getExecuteCode());
                serialVo.setSerialNo(entity.getProtocolCode());
                serialVo.setSerialPrice(entity.getTotalRewardAmount());
                serialVo.setSerialTime(entity.getCreateTime());
                serialVo.setCreateTime(entity.getCreateTime());
                serialVo.setTerminalCode(executeEntity.getTerminalCode());
                serialVo.setTerminalName(executeEntity.getTerminalName());
                serialVo.setType(Integer.valueOf(2));
                return serialVo;
            }).collect(Collectors.toList()));
        }
        return CollectionUtils.isEmpty((Collection)voList) ? null : (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)voList, ActivitiesDetailSerialVo.class, ActivitiesDetailSerialDto.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

