package com.biz.crm.sfa.business.template.action.tpm.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmPageDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM活动: ActionTpmVo: TPM活动信息
 *
 * @author ning.zhang
 * @date 2022/7/5
 */
@Slf4j
@RestController
@RequestMapping("/v1/actionTpm/actionTpm")
@Api(tags = "TPM活动: ActionTpmVo: TPM活动信息")
public class ActionTpmVoController {

  @Autowired
  private ActionTpmVoService actionTpmVoService;

  /**
   * 移动端-TPM活动分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionTpmVo> TPM活动分页信息
   */
  @ApiOperation(value = "移动端-TPM活动分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<ActionTpmVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                    @ApiParam(name = "ActionTpmPageDto", value = "分页Dto") ActionTpmPageDto dto) {
    try {
      return Result.ok(this.actionTpmVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
