package com.biz.crm.sfa.business.template.action.tpm.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * TPM活动执行陈列协议签署表
 *
 * @author ning.zhang
 * @date 2022/6/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionTpmProtocolEntity", description = "TPM活动执行陈列协议签署表")
@Entity
@TableName("sfa_action_tpm_protocol")
@Table(name = "sfa_action_tpm_protocol", indexes = {
    @Index(name = "sfa_action_tpm_protocol_index1", columnList = "execute_id"),
    @Index(name = "sfa_action_tpm_protocol_index2", columnList = "protocol_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_action_tpm_protocol", comment = "TPM活动执行陈列协议签署表")
public class ActionTpmProtocolEntity extends UuidOpEntity {

  private static final long serialVersionUID = -4726248799275955356L;

  /**
   * TPM活动执行ID
   */
  @ApiModelProperty("TPM活动执行ID")
  @Column(name = "execute_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT 'TPM活动执行ID'")
  private String executeId;

  /**
   * 协议编码
   */
  @ApiModelProperty("协议编码")
  @Column(name = "protocol_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '协议编码'")
  private String protocolCode;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  @Column(name = "product_level_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品层级编码'")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  @Column(name = "product_level_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品层级名称'")
  private String productLevelName;

  /**
   * 陈列位置类型
   */
  @ApiModelProperty("陈列位置类型")
  @Column(name = "location_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列位置类型'")
  private String locationType;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "VARCHAR(255) COMMENT '备注'")
  private String remark;

  /**
   * 陈列规格
   */
  @ApiModelProperty("陈列规格")
  @Column(name = "display_specification", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列规格'")
  private String displaySpecification;

  /**
   * 陈列件数
   */
  @ApiModelProperty("陈列件数")
  @Column(name = "display_number", columnDefinition = "decimal(9,2) COMMENT '陈列件数'")
  private BigDecimal displayNumber;

  /**
   * 陈列开始日期(yyyy-MM-dd)
   */
  @ApiModelProperty("陈列开始日期(yyyy-MM-dd)")
  @Column(name = "display_start_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列开始日期(yyyy-MM-dd)'")
  private String displayStartDate;

  /**
   * 陈列结束日期(yyyy-MM-dd)
   */
  @ApiModelProperty("陈列结束日期(yyyy-MM-dd)")
  @Column(name = "display_end_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '陈列结束日期(yyyy-MM-dd)'")
  private String displayEndDate;

  /**
   * 陈列月份
   */
  @ApiModelProperty("陈列月份")
  @Column(name = "display_moth", columnDefinition = "decimal(9,2) COMMENT '陈列月份'")
  private BigDecimal displayMoth;

  /**
   * 每月支付现金
   */
  @ApiModelProperty("每月支付现金")
  @Column(name = "moth_pay_amount", columnDefinition = "decimal(9,2) COMMENT '每月支付现金'")
  private BigDecimal mothPayAmount;

  /**
   * 合计奖励现金
   */
  @ApiModelProperty("合计奖励现金")
  @Column(name = "total_reward_amount", columnDefinition = "decimal(9,2) COMMENT '合计奖励现金'")
  private BigDecimal totalRewardAmount;

  /**
   * 奖励收款人
   */
  @ApiModelProperty("奖励收款人")
  @Column(name = "reward_payee", length = 64, columnDefinition = "VARCHAR(64) COMMENT '奖励收款人'")
  private String rewardPayee;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  @Column(name = "contact_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '联系电话'")
  private String contactPhone;

  /**
   * 签名文件编码
   */
  @ApiModelProperty("签名文件编码")
  @Column(name = "sign_file_code", columnDefinition = "VARCHAR(64) COMMENT '签名文件编码'")
  private String signFileCode;

  /**
   * 协议签署pdf文件编码
   */
  @ApiModelProperty("协议签署pdf文件编码")
  @Column(name = "pdf_file_code", columnDefinition = "VARCHAR(64) COMMENT '协议签署pdf文件编码'")
  private String pdfFileCode;

  /**
   * 协议签署pdf文件名称
   */
  @ApiModelProperty("协议签署pdf文件名称")
  @Column(name = "pdf_name", columnDefinition = "VARCHAR(255) COMMENT '协议签署pdf文件名称'")
  private String pdfName;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  @Column(name = "superior_customer_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '上级客户编码'")
  private String superiorCustomerCode;

  /**
   * 上级客户名称
   */
  @ApiModelProperty("上级客户名称")
  @Column(name = "superior_customer_name", length = 128, columnDefinition = "VARCHAR(64) COMMENT '上级客户名称'")
  private String superiorCustomerName;

  /**
   * 商品信息
   */
  @ApiModelProperty("商品信息")
  @Transient
  @TableField(exist = false)
  private List<ActionTpmProtocolProductEntity> products;
}
