package com.biz.crm.sfa.business.template.action.tpm.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM活动执行表的mybatis-plus接口类 {@link ActionTpmExecuteEntity}
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:27
 */
public interface ActionTpmExecuteMapper extends BaseMapper<ActionTpmExecuteEntity> {

  /**
   * 根据主键ID集合查询数据
   *
   * @param ids 主键ID集合
   * @return 查询结果
   */
  List<ActionTpmExecuteEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 活动执行分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<ActionTpmExecuteEntity> 活动执行分页信息
   */
  Page<ActionTpmExecuteEntity> findByConditions(Page<ActionTpmExecuteEntity> page, @Param("dto") ActionTpmExecutePageDto dto);
}

