package com.biz.crm.sfa.business.template.action.tpm.local.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * TPM活动执行基本信息model
 *
 * @author ning.zhang
 * @date 2022/6/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ActionTpmBasicModel", description = "TPM活动执行基本信息model")
public class ActionTpmBasicModel implements Serializable {

  private static final long serialVersionUID = -158364881540215227L;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * TPM活动编码
   */
  @ApiModelProperty("TPM活动编码")
  private String actionCode;

  /**
   * TPM活动明细编码
   */
  @ApiModelProperty("TPM活动明细编码")
  private String actionDetailCode;

  /**
   * TPM活动名称
   */
  @ApiModelProperty("TPM活动名称")
  private String actionName;

  /**
   * TPM活动描述
   */
  @ApiModelProperty("TPM活动描述")
  private String actionDescribe;

  /**
   * 活动总金额
   */
  @ApiModelProperty("活动总金额")
  private BigDecimal totalAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("已使用金额")
  private BigDecimal usedAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("本店已使用金额")
  private BigDecimal storeUsedAmount;

  /**
   * 支付方式
   */
  @ApiModelProperty("支付方式")
  private String payType;

  /**
   * 支付方式名称
   */
  @ApiModelProperty("支付方式名称")
  private String payTypeName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh",timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartTime;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh",timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndTime;

  /**
   * 是否采集分销订单(Y/N)
   */
  @ApiModelProperty("是否采集分销订单(Y/N)")
  private String isCollectDistributionOrder;

  /**
   * 是否签署陈列协议(Y/N)
   */
  @ApiModelProperty("是否签署陈列协议(Y/N)")
  private String isSignDisplayAgreement;

  /**
   * 是否采集数据(Y/N)
   */
  @ApiModelProperty("是否采集数据(Y/N)")
  private String isCollectData;
}
