package com.biz.crm.sfa.business.template.action.tpm.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.mapper.ActionTpmExecuteMapper;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecuteDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;

/**
 * TPM活动执行表的数据库访问类 {@link ActionTpmExecuteEntity}
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:27
 */
@Component
public class ActionTpmExecuteRepository extends ServiceImpl<ActionTpmExecuteMapper, ActionTpmExecuteEntity> {

  /**
   * 通过信息查询dto查询数据
   *
   * @param dto 参数dto
   * @return 查询结果
   */
  public List<ActionTpmExecuteEntity> findByActionTpmExecuteDto(ActionTpmExecuteDto dto) {
    return this.lambdaQuery()
        .eq(ActionTpmExecuteEntity::getTenantCode, dto.getTenantCode())
        .eq(ActionTpmExecuteEntity::getTerminalCode, dto.getTerminalCode())
        .eq(StringUtils.isNotBlank(dto.getActionCode()), ActionTpmExecuteEntity::getActionCode, dto.getActionCode())
        .eq(StringUtils.isNotBlank(dto.getActionDetailCode()), ActionTpmExecuteEntity::getActionDetailCode, dto.getActionDetailCode())
        .in(!CollectionUtils.isEmpty(dto.getActionCodes()), ActionTpmExecuteEntity::getActionCode, dto.getActionCodes())
        .in(!CollectionUtils.isEmpty(dto.getActionDetailCodes()), ActionTpmExecuteEntity::getActionDetailCode, dto.getActionDetailCodes())
        .eq(StringUtils.isNotBlank(dto.getParentCode()), ActionTpmExecuteEntity::getParentCode, dto.getParentCode())
        .eq(StringUtils.isNotBlank(dto.getDynamicKey()), ActionTpmExecuteEntity::getDynamicKey, dto.getDynamicKey())
        .list();
  }

  /**
   * 通过ID集合查询信息(包含关联信息)
   *
   * @param ids ID集合
   * @return 查询结果
   */
  public List<ActionTpmExecuteEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 活动执行分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ActionTpmExecuteEntity> 活动执行分页信息
   */
  public Page<ActionTpmExecuteEntity> findByConditions(Pageable pageable, ActionTpmExecutePageDto dto) {
    Page<ActionTpmExecuteEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
