package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * TPM活动执行表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:28
 */
@Slf4j
@Service("actionTpmExecuteService")
public class ActionTpmExecuteServiceImpl implements ActionTpmExecuteService {

  @Autowired
  private ActionTpmExecuteRepository actionTpmExecuteRepository;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired
  private ActionTpmProtocolService actionTpmProtocolService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private ActivitiesDetailService activitiesDetailService;
  @Autowired
  private TerminalVoService terminalVoService;

  @Override
  @Transactional
  public ActionTpmExecuteEntity create(ActionTpmExecuteEntity entity) {
    this.createValidate(entity);
    List<TerminalVo> terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(Lists.newArrayList(), Lists.newArrayList(entity.getTerminalCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(terminalList), "终端信息异常!");
    TerminalVo terminalVo = terminalList.get(0);
    entity.setTerminalType(terminalVo.getTerminalType());
    this.actionTpmExecuteRepository.save(entity);
    if (!CollectionUtils.isEmpty(entity.getDisplayProtocols())) {
      entity.getDisplayProtocols().forEach(protocolEntity -> protocolEntity.setExecuteId(entity.getId()));
      entity.setDisplayProtocols(this.actionTpmProtocolService.createBatch(entity, terminalVo));
    }
    return entity;
  }

  @Override
  public Page<ActionTpmExecuteEntity> findByConditions(Pageable pageable, ActionTpmExecutePageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new ActionTpmExecutePageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.actionTpmExecuteRepository.findByConditions(pageable, dto);
  }

  /**
   * 创建验证
   *
   * @param entity 验证对象
   */
  private void createValidate(ActionTpmExecuteEntity entity) {
    Validate.notNull(entity, "新增数据时，对象信息不能为空！");
    Validate.notBlank(entity.getActionCode(), "新增数据时，TPM活动编码不能为空！");
    Validate.notBlank(entity.getActionName(), "新增数据时，TPM活动名称不能为空！");
    Validate.notBlank(entity.getActionDetailCode(), "新增数据时，TPM活动明细编码不能为空！");
    Validate.notBlank(entity.getTerminalCode(), "新增数据时，终端编码不能为空！");
    Validate.notBlank(entity.getTerminalName(), "新增数据时，终端名称不能为空！");
    entity.setId(null);
    entity.setTenantCode(TenantUtils.getTenantCode());
    entity.setExecuteCode(this.generateCodeService.generateCode("ATE", 1).get(0));
    ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findDetailByActivitiesDetailCode(entity.getActionDetailCode());
    Validate.isTrue(Objects.nonNull(activitiesDetailVo)
            && Objects.nonNull(activitiesDetailVo.getActivities())
        , "新增数据时，活动信息异常！");
    ActivitiesVo activities = activitiesDetailVo.getActivities();
    entity.setActionStartDate(activities.getBeginTime());
    entity.setActionEndDate(activities.getEndTime());
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    entity.setPostCode(loginDetails.getPostCode());
    entity.setPostName(loginDetails.getPostName());
    entity.setOrgCode(loginDetails.getOrgCode());
    entity.setOrgName(loginDetails.getOrgName());

  }
}
