package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmExecuteVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * TPM活动执行VO信息服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@Slf4j
@Service
public class ActionTpmExecuteVoServiceImpl implements ActionTpmExecuteVoService {

  @Autowired
  private ActionTpmExecuteRepository actionTpmExecuteRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private ActivitiesDetailService activitiesDetailService;

  @Override
  public ActionTpmExecuteVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    List<ActionTpmExecuteEntity> executeEntities = this.actionTpmExecuteRepository.findByIds(Lists.newArrayList(id));
    if (CollectionUtils.isEmpty(executeEntities)) {
      return null;
    }
    ActionTpmExecuteVo executeVo = this.nebulaToolkitService.copyObjectByBlankList(executeEntities.get(0), ActionTpmExecuteVo.class, HashSet.class, ArrayList.class);
    ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findDetailByActivitiesDetailCode(executeVo.getActionDetailCode());
    activitiesDetailVo = ObjectUtils.defaultIfNull(activitiesDetailVo, new ActivitiesDetailVo());
    executeVo.setPhotoRequires(activitiesDetailVo.getPhotoRequires());
    executeVo.setFieldsCollectTemplateStruct(activitiesDetailVo.getFieldsCollectTemplateStruct());
    if (!CollectionUtils.isEmpty(activitiesDetailVo.getActivitiesDetailCollects())) {
      executeVo.setActivitiesDetailCollects(activitiesDetailVo.getActivitiesDetailCollects().stream().filter(collectVo
          -> Objects.equals(executeVo.getExecuteCode(), collectVo.getBtNo())).collect(Collectors.toList()));
    }
    if (!CollectionUtils.isEmpty(activitiesDetailVo.getFieldsCollectTemplates())) {
      executeVo.setFieldsCollectTemplates(activitiesDetailVo.getFieldsCollectTemplates().stream().filter(fieldsCollectTemplateFeginVo
          -> Objects.equals(executeVo.getExecuteCode(), fieldsCollectTemplateFeginVo.getBtNo())).collect(Collectors.toList()));
    }
    ActivitiesVo activitiesVo = ObjectUtils.defaultIfNull(activitiesDetailVo.getActivities(), new ActivitiesVo());
    executeVo.setActionDescribe(activitiesVo.getRemark());
    return executeVo;
  }
}
