package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolProductEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmProtocolProductRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolProductService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * TPM活动执行陈列协议签署商品表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:33
 */
@Slf4j
@Service("actionTpmProtocolProductService")
public class ActionTpmProtocolProductServiceImpl implements ActionTpmProtocolProductService {

  @Autowired
  private ActionTpmProtocolProductRepository actionTpmProtocolProductRepository;

  @Override
  @Transactional
  public List<ActionTpmProtocolProductEntity> createBatch(List<ActionTpmProtocolProductEntity> entities) {
    this.createValidate(entities);
    this.actionTpmProtocolProductRepository.saveBatch(entities);
    return entities;
  }

  /**
   * 创建验证
   *
   * @param entities 验证对象
   */
  private void createValidate(List<ActionTpmProtocolProductEntity> entities) {
    Validate.notNull(!CollectionUtils.isEmpty(entities), "新增数据时，陈列协议商品对象信息不能为空！");
    entities.forEach(productEntity -> {
      productEntity.setId(null);
      Validate.notBlank(productEntity.getProductCode(), "新增数据时，陈列协议商品编码不能为空！");
      Validate.notBlank(productEntity.getProductName(), "新增数据时，陈列协议商品名称不能为空！");
    });
  }
}
