package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.biz.crm.dms.business.itextpdf.sdk.service.ITextPdfVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolProductEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmProtocolRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolProductService;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.constant.TemplateActionTpmConstant;
import com.biz.crm.sfa.business.template.action.tpm.sdk.enums.DisplayLocationType;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * TPM活动执行陈列协议签署表服务实现类
 *
 * @author ning.zhang
 * @date 2022-07-01 10:34:32
 */
@Slf4j
@Service("actionTpmProtocolService")
public class ActionTpmProtocolServiceImpl implements ActionTpmProtocolService {
  @Autowired(required = false)
  private ActionTpmProtocolRepository actionTpmProtocolRepository;
  @Autowired(required = false)
  private ActionTpmProtocolProductService actionTpmProtocolProductService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private ITextPdfVoService iTextPdfVoService;
  @Autowired(required = false)
  private FileHandleService fileHandleService;
  @Override
  @Transactional
  public List<ActionTpmProtocolEntity> createBatch(ActionTpmExecuteEntity entity, TerminalVo terminalVo) {
    this.createValidate(entity);
    List<ActionTpmProtocolEntity> entities = entity.getDisplayProtocols();
    this.buildDisplayPdf(entity, terminalVo, entities);
    this.actionTpmProtocolRepository.saveBatch(entities);
    List<ActionTpmProtocolProductEntity> productEntities = entities.stream().flatMap(protocolEntity
        -> protocolEntity.getProducts().stream().map(productEntity -> {
      productEntity.setProtocolId(protocolEntity.getId());
      return productEntity;
    })).collect(Collectors.toList());
    this.actionTpmProtocolProductService.createBatch(productEntities);
    return entities;
  }

  /**
   * 构建陈列协议签署pdf信息
   *
   * @param entity     执行信息
   * @param terminalVo 终端信息
   * @param entities   协议信息
   */
  private void buildDisplayPdf(ActionTpmExecuteEntity entity, TerminalVo terminalVo, List<ActionTpmProtocolEntity> entities) {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    entities.forEach(protocolEntity -> {
      //转换为Map
      Map<String, Object> dataMap = Maps.newHashMap();
      dataMap.put("activityCode", entity.getActionCode());
      dataMap.put("contactPhone", protocolEntity.getContactPhone());
      dataMap.put("currUserName", loginDetails.getUsername());
      dataMap.put("currUserPhone", loginDetails.getPhone());
      dataMap.put("dealerName", protocolEntity.getSuperiorCustomerName());
      dataMap.put("displayEndTime", protocolEntity.getDisplayEndDate());
      dataMap.put("displayInfo", String.join("、"
          , protocolEntity.getProducts().stream().map(ActionTpmProtocolProductEntity::getProductName).collect(Collectors.toList())));
      dataMap.put("displayMonth", protocolEntity.getDisplayMoth());
      dataMap.put("displayNumber", protocolEntity.getDisplayNumber());
      dataMap.put("displayPlace", DisplayLocationType.getByDictCode(protocolEntity.getLocationType()).getValue());
      dataMap.put("displaySpecs", protocolEntity.getDisplaySpecification());
      dataMap.put("displayStartTime", protocolEntity.getDisplayStartDate());
      dataMap.put("monthPayAmount", protocolEntity.getMothPayAmount());
      dataMap.put("payee", protocolEntity.getRewardPayee());
      dataMap.put("remarks", protocolEntity.getRemark());
      dataMap.put("terminalAddr", terminalVo.getTerminalAddress());
      dataMap.put("terminalName", terminalVo.getTerminalName());
      String terminalPhone = "";
      if (!CollectionUtils.isEmpty(terminalVo.getContacts())) {
        List<TerminalContactVo> contactVos = terminalVo.getContacts().stream().filter(TerminalContactVo::getContactMain).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(contactVos)) {
          terminalPhone = contactVos.get(0).getContactPhone();
        }
      }
      dataMap.put("terminalPhone", terminalPhone);
      dataMap.put("totalAmount", protocolEntity.getTotalRewardAmount());
      String[] startTime = protocolEntity.getDisplayStartDate().split("-");
      String[] endTime = protocolEntity.getDisplayEndDate().split("-");
      dataMap.put("startYear", startTime[0]);
      dataMap.put("startMonth", startTime[1]);
      dataMap.put("startDay", startTime[2]);
      dataMap.put("endYear", endTime[0]);
      dataMap.put("endMonth", endTime[1]);
      dataMap.put("endDay", endTime[2]);
      //当前时间
      dataMap.put("currDate", DateFormatUtils.format(new Date(), TemplateActionTpmConstant.YYYY_MM_DD_CH_STR));
      dataMap.put("gifts", new ArrayList<>());
      WordTemplateDataVo dataVo = new WordTemplateDataVo();
      dataVo.setLeftOffset(340);
      dataVo.setTopOffset(-10);
      dataVo.setTemplateName("DocumentTreatyMoney.xml");
      dataVo.setZipTemplateName("DocumentTreatyMoney.zip");
      dataVo.setFileName(protocolEntity.getProtocolCode());
      dataVo.setTabText("代表（签字）");
      dataVo.setSignFileCode(protocolEntity.getSignFileCode());
      dataVo.setDataMap(dataMap);
      OrdinaryFileVo ordinaryFileVo = this.iTextPdfVoService.createWordDocxToPdfFile(dataVo);
      Validate.notNull(ordinaryFileVo, "陈列协议签署失败");
      protocolEntity.setPdfFileCode(ordinaryFileVo.getId());
      protocolEntity.setPdfName(ordinaryFileVo.getFileName());
    });
  }

  /**
   * 创建验证
   *
   * @param entity 验证对象
   */
  private void createValidate(ActionTpmExecuteEntity entity) {
    Validate.isTrue(Objects.nonNull(entity) && !CollectionUtils.isEmpty(entity.getDisplayProtocols()), "新增数据时，协议对象信息不能为空！");
    entity.getDisplayProtocols().forEach(protocolEntity -> {
      protocolEntity.setId(null);
      protocolEntity.setProtocolCode(this.generateCodeService.generateCode("SPR", 1).get(0));
      Validate.notBlank(protocolEntity.getProductLevelCode(), "新增数据时，陈列协议产品层级编码不能为空！");
      Validate.notBlank(protocolEntity.getProductLevelName(), "新增数据时，陈列协议产品层级名称不能为空！");
      Validate.notNull(DisplayLocationType.getByDictCode(protocolEntity.getLocationType()), "新增数据时，陈列协议陈列位置类型错误！");
      Validate.notBlank(protocolEntity.getContactPhone(), "新增数据时，陈列协议联系电话不能为空！");
      Validate.notBlank(protocolEntity.getRewardPayee(), "新增数据时，陈列协议奖励收款人不能为空！");
      Validate.notBlank(protocolEntity.getDisplaySpecification(), "新增数据时，陈列协议陈列规格不能为空！");
      Validate.notBlank(protocolEntity.getDisplayEndDate(), "新增数据时，陈列协议陈列结束日期不能为空！");
      Validate.notBlank(protocolEntity.getDisplayStartDate(), "新增数据时，陈列协议陈列开始日期不能为空！");
      Validate.notBlank(protocolEntity.getSignFileCode(), "新增数据时，陈列协议签名不能为空！");
      Validate.notBlank(protocolEntity.getSuperiorCustomerCode(), "新增数据时，陈列协议上级客户编码不能为空！");
      Validate.notBlank(protocolEntity.getSuperiorCustomerName(), "新增数据时，陈列协议上级客户名称不能为空！");
      Validate.isTrue(DateTimeValidateUtil.validateDate(protocolEntity.getDisplayStartDate())
          , "非法的陈列开始日期格式，可用的格式：[yyyy-MM-dd]");
      Validate.isTrue(DateTimeValidateUtil.validateDate(protocolEntity.getDisplayEndDate())
          , "非法的陈列结束日期格式，可用的格式：[yyyy-MM-dd]");
      Validate.isTrue(protocolEntity.getDisplayEndDate().compareTo(protocolEntity.getDisplayStartDate()) >= 0
          , "陈列开始日期不能晚于陈列结束日期！");
      Validate.isTrue(Objects.nonNull(protocolEntity.getDisplayNumber()) && protocolEntity.getDisplayNumber().compareTo(BigDecimal.ZERO) > 0
          , "新增数据时，陈列协议陈列月份数据错误！");
      Validate.isTrue(Objects.nonNull(protocolEntity.getDisplayNumber()) && protocolEntity.getDisplayNumber().compareTo(BigDecimal.ZERO) > 0
          , "新增数据时，陈列协议陈列件数数据错误！");
      Validate.isTrue(Objects.nonNull(protocolEntity.getMothPayAmount()) && protocolEntity.getMothPayAmount().compareTo(BigDecimal.ZERO) > 0
          , "新增数据时，陈列协议每月支付现金数据错误！");
      Validate.isTrue(Objects.nonNull(protocolEntity.getTotalRewardAmount()) && protocolEntity.getTotalRewardAmount().compareTo(BigDecimal.ZERO) > 0
          , "新增数据时，陈列协议合计奖励现金数据错误！");
      Validate.isTrue(!CollectionUtils.isEmpty(protocolEntity.getProducts()), "新增数据时，陈列协议商品信息数据不能为空！");
    });
  }
}
