package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecuteDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmPageDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * TPM活动vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/7/5
 */
@Slf4j
@Service
public class ActionTpmVoServiceImpl implements ActionTpmVoService {

  @Autowired
  private ActivitiesDetailService activitiesDetailService;
  @Autowired
  private TerminalSupplyVoService terminalSupplyVoService;
  @Autowired
  private ActionTpmExecuteRepository actionTpmExecuteRepository;
  @Autowired
  private TerminalVoService terminalVoService;

  @Override
  public Page<ActionTpmVo> findByConditions(Pageable pageable, ActionTpmPageDto dto) {
    if (Objects.isNull(dto) || StringUtils.isBlank(dto.getTerminalCode())) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    List<TerminalVo> terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(Lists.newArrayList(), Lists.newArrayList(dto.getTerminalCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(terminalList), "终端信息异常!");
    if (CollectionUtils.isEmpty(terminalList) || CollectionUtils.isEmpty(terminalList.get(0).getOrgList())) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    ActivitiesDetailDto detailDto = new ActivitiesDetailDto();
    detailDto.setOrgCodes(terminalList.get(0).getOrgList().stream().map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet()));
    List<TerminalSupplyVo> terminalSupplyList = this.terminalSupplyVoService.findByTerminalCodes(Lists.newArrayList(dto.getTerminalCode()));

    if (!CollectionUtils.isEmpty(terminalSupplyList)) {
      detailDto.setCustomerCodes(terminalSupplyList.stream().map(TerminalSupplyVo::getCustomerCode).collect(Collectors.toSet()));
    }
    detailDto.setTerminalCode(dto.getTerminalCode());
    detailDto.setActivitiesName(dto.getActionName());
    detailDto.setTenantCode(TenantUtils.getTenantCode());
    detailDto.setIsExecute(dto.getIsExecute());
    detailDto.setIsValid(dto.getIsValid());
    Page<ActivitiesDetailVo> activitiesDetailPage = this.activitiesDetailService.findByConditions(pageable, detailDto);
    Page<ActionTpmVo> pageResult = new Page<>(activitiesDetailPage.getCurrent(), activitiesDetailPage.getSize(), activitiesDetailPage.getTotal());
    if (CollectionUtils.isEmpty(activitiesDetailPage.getRecords())) {
      return pageResult;
    }
    pageResult.setRecords(this.buildActionTpmVo(dto, activitiesDetailPage.getRecords()));
    return pageResult;
  }

  /**
   * 构建活动信息VO
   *
   * @param dto  参数dto
   * @param list tpm活动信息集合
   * @return 活动信息VO集合
   */
  private List<ActionTpmVo> buildActionTpmVo(ActionTpmPageDto dto, List<ActivitiesDetailVo> list) {
    Set<String> actionDetailCodes = Sets.newHashSet();
    List<ActionTpmVo> resultList = list.stream().map(detailVo -> {
      ActivitiesVo activitiesVo = ObjectUtils.defaultIfNull(detailVo.getActivities(), new ActivitiesVo());
      ActionTpmVo actionTpmVo = new ActionTpmVo();
      actionTpmVo.setActionCode(detailVo.getActivitiesCode());
      actionTpmVo.setActionDetailCode(detailVo.getActivitiesDetailCode());
      actionTpmVo.setActionDescribe(activitiesVo.getRemark());
      actionTpmVo.setActionEndTime(activitiesVo.getEndTime());
      actionTpmVo.setActionName(detailVo.getActivitiesName());
      actionTpmVo.setActionStartTime(activitiesVo.getBeginTime());
      actionTpmVo.setPayType(detailVo.getPayType());
      actionTpmVo.setPayTypeName(detailVo.getPayTypeName());
      actionTpmVo.setStoreUsedAmount(ObjectUtils.defaultIfNull(detailVo.getTerminalAmount(), BigDecimal.ZERO));
      actionTpmVo.setTotalAmount(ObjectUtils.defaultIfNull(detailVo.getApplyAmount(), BigDecimal.ZERO));
      actionTpmVo.setUsedAmount(ObjectUtils.defaultIfNull(detailVo.getTotalAmount(), BigDecimal.ZERO));
      actionDetailCodes.add(detailVo.getActivitiesDetailCode());
      return actionTpmVo;
    }).collect(Collectors.toList());
    ActionTpmExecuteDto executeDto = new ActionTpmExecuteDto();
    executeDto.setTenantCode(TenantUtils.getTenantCode());
    executeDto.setActionDetailCodes(actionDetailCodes);
    executeDto.setParentCode(dto.getParentCode());
    executeDto.setDynamicKey(dto.getDynamicKey());
    executeDto.setTerminalCode(dto.getTerminalCode());
    List<ActionTpmExecuteEntity> executeEntities = this.actionTpmExecuteRepository.findByActionTpmExecuteDto(executeDto);
    Map<String, ActionTpmExecuteEntity> executeMap = !CollectionUtils.isEmpty(executeEntities)
        ? executeEntities.stream().collect(Collectors.toMap(ActionTpmExecuteEntity::getActionDetailCode, t -> t, (a, b) -> a))
        : Maps.newHashMap();
    resultList.forEach(actionTpmVo -> {
      actionTpmVo.setHaveExecute(Objects.isNull(executeMap.get(actionTpmVo.getActionDetailCode()))
          ? BooleanEnum.FALSE.getCapital() : BooleanEnum.TRUE.getCapital());
    });
    return resultList;
  }
}
