/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmExecuteService;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecutePageDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="actionTpmExecuteService")
public class ActionTpmExecuteServiceImpl
implements ActionTpmExecuteService {
    private static final Logger log = LoggerFactory.getLogger(ActionTpmExecuteServiceImpl.class);
    @Autowired
    private ActionTpmExecuteRepository actionTpmExecuteRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private ActionTpmProtocolService actionTpmProtocolService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private TerminalVoService terminalVoService;

    @Override
    @Transactional
    public ActionTpmExecuteEntity create(ActionTpmExecuteEntity entity) {
        this.createValidate(entity);
        List terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newArrayList(), (List)Lists.newArrayList((Object[])new String[]{entity.getTerminalCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)terminalList) ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u4fe1\u606f\u5f02\u5e38!", (Object[])new Object[0]);
        TerminalVo terminalVo = (TerminalVo)terminalList.get(0);
        entity.setTerminalType(terminalVo.getTerminalType());
        this.actionTpmExecuteRepository.save((Object)entity);
        if (!CollectionUtils.isEmpty(entity.getDisplayProtocols())) {
            entity.getDisplayProtocols().forEach(protocolEntity -> protocolEntity.setExecuteId(entity.getId()));
            entity.setDisplayProtocols(this.actionTpmProtocolService.createBatch(entity, terminalVo));
        }
        return entity;
    }

    @Override
    public Page<ActionTpmExecuteEntity> findByConditions(Pageable pageable, ActionTpmExecutePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (ActionTpmExecutePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new ActionTpmExecutePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.actionTpmExecuteRepository.findByConditions(pageable, dto);
    }

    private void createValidate(ActionTpmExecuteEntity entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getActionCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0cTPM\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getActionName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0cTPM\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getActionDetailCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0cTPM\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getTerminalCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getTerminalName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.setId(null);
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setExecuteCode((String)this.generateCodeService.generateCode("ATE", 1).get(0));
        ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findDetailByActivitiesDetailCode(entity.getActionDetailCode());
        Validate.isTrue((Objects.nonNull(activitiesDetailVo) && Objects.nonNull(activitiesDetailVo.getActivities()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4fe1\u606f\u5f02\u5e38\uff01", (Object[])new Object[0]);
        ActivitiesVo activities = activitiesDetailVo.getActivities();
        entity.setActionStartDate(activities.getBeginTime());
        entity.setActionEndDate(activities.getEndTime());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        entity.setPostCode(loginDetails.getPostCode());
        entity.setPostName(loginDetails.getPostName());
        entity.setOrgCode(loginDetails.getOrgCode());
        entity.setOrgName(loginDetails.getOrgName());
    }
}

