/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmExecuteVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionTpmExecuteVoServiceImpl
implements ActionTpmExecuteVoService {
    private static final Logger log = LoggerFactory.getLogger(ActionTpmExecuteVoServiceImpl.class);
    @Autowired
    private ActionTpmExecuteRepository actionTpmExecuteRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;

    public ActionTpmExecuteVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<ActionTpmExecuteEntity> executeEntities = this.actionTpmExecuteRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(executeEntities)) {
            return null;
        }
        ActionTpmExecuteVo executeVo = (ActionTpmExecuteVo)this.nebulaToolkitService.copyObjectByBlankList((Object)executeEntities.get(0), ActionTpmExecuteVo.class, HashSet.class, ArrayList.class, new String[0]);
        ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findDetailByActivitiesDetailCode(executeVo.getActionDetailCode());
        activitiesDetailVo = (ActivitiesDetailVo)ObjectUtils.defaultIfNull((Object)activitiesDetailVo, (Object)new ActivitiesDetailVo());
        executeVo.setPhotoRequires(activitiesDetailVo.getPhotoRequires());
        executeVo.setFieldsCollectTemplateStruct(activitiesDetailVo.getFieldsCollectTemplateStruct());
        if (!CollectionUtils.isEmpty((Collection)activitiesDetailVo.getActivitiesDetailCollects())) {
            executeVo.setActivitiesDetailCollects(activitiesDetailVo.getActivitiesDetailCollects().stream().filter(collectVo -> Objects.equals(executeVo.getExecuteCode(), collectVo.getBtNo())).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)activitiesDetailVo.getFieldsCollectTemplates())) {
            executeVo.setFieldsCollectTemplates(activitiesDetailVo.getFieldsCollectTemplates().stream().filter(fieldsCollectTemplateFeginVo -> Objects.equals(executeVo.getExecuteCode(), fieldsCollectTemplateFeginVo.getBtNo())).collect(Collectors.toList()));
        }
        ActivitiesVo activitiesVo = (ActivitiesVo)ObjectUtils.defaultIfNull((Object)activitiesDetailVo.getActivities(), (Object)new ActivitiesVo());
        executeVo.setActionDescribe(activitiesVo.getRemark());
        return executeVo;
    }
}

