/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.dms.business.itextpdf.sdk.dto.WordTemplateDataVo;
import com.biz.crm.dms.business.itextpdf.sdk.service.ITextPdfVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmProtocolProductEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmProtocolRepository;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolProductService;
import com.biz.crm.sfa.business.template.action.tpm.local.service.ActionTpmProtocolService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.enums.DisplayLocationType;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="actionTpmProtocolService")
public class ActionTpmProtocolServiceImpl
implements ActionTpmProtocolService {
    private static final Logger log = LoggerFactory.getLogger(ActionTpmProtocolServiceImpl.class);
    @Autowired(required=false)
    private ActionTpmProtocolRepository actionTpmProtocolRepository;
    @Autowired(required=false)
    private ActionTpmProtocolProductService actionTpmProtocolProductService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ITextPdfVoService iTextPdfVoService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    @Override
    @Transactional
    public List<ActionTpmProtocolEntity> createBatch(ActionTpmExecuteEntity entity, TerminalVo terminalVo) {
        this.createValidate(entity);
        List<ActionTpmProtocolEntity> entities = entity.getDisplayProtocols();
        this.buildDisplayPdf(entity, terminalVo, entities);
        this.actionTpmProtocolRepository.saveBatch(entities);
        List<ActionTpmProtocolProductEntity> productEntities = entities.stream().flatMap(protocolEntity -> protocolEntity.getProducts().stream().map(productEntity -> {
            productEntity.setProtocolId(protocolEntity.getId());
            return productEntity;
        })).collect(Collectors.toList());
        this.actionTpmProtocolProductService.createBatch(productEntities);
        return entities;
    }

    private void buildDisplayPdf(ActionTpmExecuteEntity entity, TerminalVo terminalVo, List<ActionTpmProtocolEntity> entities) {
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        entities.forEach(protocolEntity -> {
            List contactVos;
            HashMap dataMap = Maps.newHashMap();
            dataMap.put("activityCode", entity.getActionCode());
            dataMap.put("contactPhone", protocolEntity.getContactPhone());
            dataMap.put("currUserName", loginDetails.getUsername());
            dataMap.put("currUserPhone", loginDetails.getPhone());
            dataMap.put("dealerName", protocolEntity.getSuperiorCustomerName());
            dataMap.put("displayEndTime", protocolEntity.getDisplayEndDate());
            dataMap.put("displayInfo", String.join((CharSequence)"\u3001", protocolEntity.getProducts().stream().map(ActionTpmProtocolProductEntity::getProductName).collect(Collectors.toList())));
            dataMap.put("displayMonth", protocolEntity.getDisplayMoth());
            dataMap.put("displayNumber", protocolEntity.getDisplayNumber());
            dataMap.put("displayPlace", DisplayLocationType.getByDictCode((String)protocolEntity.getLocationType()).getValue());
            dataMap.put("displaySpecs", protocolEntity.getDisplaySpecification());
            dataMap.put("displayStartTime", protocolEntity.getDisplayStartDate());
            dataMap.put("monthPayAmount", protocolEntity.getMothPayAmount());
            dataMap.put("payee", protocolEntity.getRewardPayee());
            dataMap.put("remarks", protocolEntity.getRemark());
            dataMap.put("terminalAddr", terminalVo.getTerminalAddress());
            dataMap.put("terminalName", terminalVo.getTerminalName());
            String terminalPhone = "";
            if (!CollectionUtils.isEmpty((Collection)terminalVo.getContacts()) && !CollectionUtils.isEmpty(contactVos = terminalVo.getContacts().stream().filter(TerminalContactVo::getContactMain).collect(Collectors.toList()))) {
                terminalPhone = ((TerminalContactVo)contactVos.get(0)).getContactPhone();
            }
            dataMap.put("terminalPhone", terminalPhone);
            dataMap.put("totalAmount", protocolEntity.getTotalRewardAmount());
            String[] startTime = protocolEntity.getDisplayStartDate().split("-");
            String[] endTime = protocolEntity.getDisplayEndDate().split("-");
            dataMap.put("startYear", startTime[0]);
            dataMap.put("startMonth", startTime[1]);
            dataMap.put("startDay", startTime[2]);
            dataMap.put("endYear", endTime[0]);
            dataMap.put("endMonth", endTime[1]);
            dataMap.put("endDay", endTime[2]);
            dataMap.put("currDate", DateFormatUtils.format((Date)new Date(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
            dataMap.put("gifts", new ArrayList());
            WordTemplateDataVo dataVo = new WordTemplateDataVo();
            dataVo.setLeftOffset(Integer.valueOf(340));
            dataVo.setTopOffset(Integer.valueOf(-10));
            dataVo.setTemplateName("DocumentTreatyMoney.xml");
            dataVo.setZipTemplateName("DocumentTreatyMoney.zip");
            dataVo.setFileName(protocolEntity.getProtocolCode());
            dataVo.setTabText("\u4ee3\u8868\uff08\u7b7e\u5b57\uff09");
            dataVo.setSignFileCode(protocolEntity.getSignFileCode());
            dataVo.setDataMap((Map)dataMap);
            OrdinaryFileVo ordinaryFileVo = this.iTextPdfVoService.createWordDocxToPdfFile(dataVo);
            Validate.notNull((Object)ordinaryFileVo, (String)"\u9648\u5217\u534f\u8bae\u7b7e\u7f72\u5931\u8d25", (Object[])new Object[0]);
            protocolEntity.setPdfFileCode(ordinaryFileVo.getId());
            protocolEntity.setPdfName(ordinaryFileVo.getFileName());
        });
    }

    private void createValidate(ActionTpmExecuteEntity entity) {
        Validate.isTrue((Objects.nonNull((Object)entity) && !CollectionUtils.isEmpty(entity.getDisplayProtocols()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u534f\u8bae\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.getDisplayProtocols().forEach(protocolEntity -> {
            protocolEntity.setId(null);
            protocolEntity.setProtocolCode((String)this.generateCodeService.generateCode("SPR", 1).get(0));
            Validate.notBlank((CharSequence)protocolEntity.getProductLevelCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getProductLevelName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)DisplayLocationType.getByDictCode((String)protocolEntity.getLocationType()), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u4f4d\u7f6e\u7c7b\u578b\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getContactPhone(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getRewardPayee(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u5956\u52b1\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getDisplaySpecification(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getDisplayEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getDisplayStartDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getSignFileCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getSuperiorCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)protocolEntity.getSuperiorCustomerName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u4e0a\u7ea7\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)protocolEntity.getDisplayStartDate()), (String)"\u975e\u6cd5\u7684\u9648\u5217\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
            Validate.isTrue((boolean)DateTimeValidateUtil.validateDate((String)protocolEntity.getDisplayEndDate()), (String)"\u975e\u6cd5\u7684\u9648\u5217\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Object[])new Object[0]);
            Validate.isTrue((protocolEntity.getDisplayEndDate().compareTo(protocolEntity.getDisplayStartDate()) >= 0 ? 1 : 0) != 0, (String)"\u9648\u5217\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u9648\u5217\u7ed3\u675f\u65e5\u671f\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(protocolEntity.getDisplayNumber()) && protocolEntity.getDisplayNumber().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u6708\u4efd\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(protocolEntity.getDisplayNumber()) && protocolEntity.getDisplayNumber().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u9648\u5217\u4ef6\u6570\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(protocolEntity.getMothPayAmount()) && protocolEntity.getMothPayAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u6bcf\u6708\u652f\u4ed8\u73b0\u91d1\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(protocolEntity.getTotalRewardAmount()) && protocolEntity.getTotalRewardAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u5408\u8ba1\u5956\u52b1\u73b0\u91d1\u6570\u636e\u9519\u8bef\uff01", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(protocolEntity.getProducts()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9648\u5217\u534f\u8bae\u5546\u54c1\u4fe1\u606f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }
}

