/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.action.tpm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalSupplyVoService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.sfa.business.template.action.tpm.local.entity.ActionTpmExecuteEntity;
import com.biz.crm.sfa.business.template.action.tpm.local.repository.ActionTpmExecuteRepository;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmExecuteDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.dto.ActionTpmPageDto;
import com.biz.crm.sfa.business.template.action.tpm.sdk.service.ActionTpmVoService;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmVo;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionTpmVoServiceImpl
implements ActionTpmVoService {
    private static final Logger log = LoggerFactory.getLogger(ActionTpmVoServiceImpl.class);
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private TerminalSupplyVoService terminalSupplyVoService;
    @Autowired
    private ActionTpmExecuteRepository actionTpmExecuteRepository;
    @Autowired
    private TerminalVoService terminalVoService;

    public Page<ActionTpmVo> findByConditions(Pageable pageable, ActionTpmPageDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getTerminalCode())) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        List terminalList = this.terminalVoService.findDetailsByIdsOrTerminalCodes((List)Lists.newArrayList(), (List)Lists.newArrayList((Object[])new String[]{dto.getTerminalCode()}));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)terminalList) ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u4fe1\u606f\u5f02\u5e38!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)terminalList) || CollectionUtils.isEmpty((Collection)((TerminalVo)terminalList.get(0)).getOrgList())) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        ActivitiesDetailDto detailDto = new ActivitiesDetailDto();
        detailDto.setOrgCodes(((TerminalVo)terminalList.get(0)).getOrgList().stream().map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet()));
        List terminalSupplyList = this.terminalSupplyVoService.findByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{dto.getTerminalCode()}));
        if (!CollectionUtils.isEmpty((Collection)terminalSupplyList)) {
            detailDto.setCustomerCodes(terminalSupplyList.stream().map(TerminalSupplyVo::getCustomerCode).collect(Collectors.toSet()));
        }
        detailDto.setTerminalCode(dto.getTerminalCode());
        detailDto.setActivitiesName(dto.getActionName());
        detailDto.setTenantCode(TenantUtils.getTenantCode());
        detailDto.setIsExecute(dto.getIsExecute());
        detailDto.setIsValid(dto.getIsValid());
        Page activitiesDetailPage = this.activitiesDetailService.findByConditions(pageable, detailDto);
        Page pageResult = new Page(activitiesDetailPage.getCurrent(), activitiesDetailPage.getSize(), activitiesDetailPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)activitiesDetailPage.getRecords())) {
            return pageResult;
        }
        pageResult.setRecords(this.buildActionTpmVo(dto, activitiesDetailPage.getRecords()));
        return pageResult;
    }

    private List<ActionTpmVo> buildActionTpmVo(ActionTpmPageDto dto, List<ActivitiesDetailVo> list) {
        HashSet actionDetailCodes = Sets.newHashSet();
        List<ActionTpmVo> resultList = list.stream().map(detailVo -> {
            ActivitiesVo activitiesVo = (ActivitiesVo)ObjectUtils.defaultIfNull((Object)detailVo.getActivities(), (Object)new ActivitiesVo());
            ActionTpmVo actionTpmVo = new ActionTpmVo();
            actionTpmVo.setActionCode(detailVo.getActivitiesCode());
            actionTpmVo.setActionDetailCode(detailVo.getActivitiesDetailCode());
            actionTpmVo.setActionDescribe(activitiesVo.getRemark());
            actionTpmVo.setActionEndTime(activitiesVo.getEndTime());
            actionTpmVo.setActionName(detailVo.getActivitiesName());
            actionTpmVo.setActionStartTime(activitiesVo.getBeginTime());
            actionTpmVo.setPayType(detailVo.getPayType());
            actionTpmVo.setPayTypeName(detailVo.getPayTypeName());
            actionTpmVo.setStoreUsedAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getTerminalAmount(), (Object)BigDecimal.ZERO));
            actionTpmVo.setTotalAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getApplyAmount(), (Object)BigDecimal.ZERO));
            actionTpmVo.setUsedAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)detailVo.getTotalAmount(), (Object)BigDecimal.ZERO));
            actionDetailCodes.add(detailVo.getActivitiesDetailCode());
            return actionTpmVo;
        }).collect(Collectors.toList());
        ActionTpmExecuteDto executeDto = new ActionTpmExecuteDto();
        executeDto.setTenantCode(TenantUtils.getTenantCode());
        executeDto.setActionDetailCodes((Set)actionDetailCodes);
        executeDto.setParentCode(dto.getParentCode());
        executeDto.setDynamicKey(dto.getDynamicKey());
        executeDto.setTerminalCode(dto.getTerminalCode());
        List<ActionTpmExecuteEntity> executeEntities = this.actionTpmExecuteRepository.findByActionTpmExecuteDto(executeDto);
        HashMap executeMap = !CollectionUtils.isEmpty(executeEntities) ? executeEntities.stream().collect(Collectors.toMap(ActionTpmExecuteEntity::getActionDetailCode, t -> t, (a, b) -> a)) : Maps.newHashMap();
        resultList.forEach(actionTpmVo -> actionTpmVo.setHaveExecute(Objects.isNull(executeMap.get(actionTpmVo.getActionDetailCode())) ? BooleanEnum.FALSE.getCapital() : BooleanEnum.TRUE.getCapital()));
        return resultList;
    }
}

