package com.biz.crm.sfa.business.template.action.tpm.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * TPM活动执行信息分页查询dto
 *
 * @author ning.zhang
 * @date 2022/7/8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmExecutePageDto", description = "TPM活动执行信息分页查询dto")
public class ActionTpmExecutePageDto extends TenantDto {

  /**
   * TPM活动编码
   */
  @ApiModelProperty(value = "TPM活动编码")
  private String actionCode;

  /**
   * TPM活动名称
   */
  @ApiModelProperty(value = "TPM活动名称")
  private String actionName;

  /**
   * 终端编码
   */
  @ApiModelProperty(value = "终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty(value = "终端名称")
  private String terminalName;

  /**
   * 创建开始时间
   */
  @ApiModelProperty(value = "创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty(value = "创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
