package com.biz.crm.sfa.business.template.action.tpm.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * TPM活动信息分页查询dto
 *
 * @author ning.zhang
 * @date 2022/7/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmPageDto", description = "TPM活动信息分页查询dto")
public class ActionTpmPageDto extends TenantDto {

  /**
   * TPM活动名称
   */
  @ApiModelProperty("TPM活动名称")
  private String actionName;

  /**
   * 终端编码
   */
  @ApiModelProperty(value = "终端编码", required = true)
  private String terminalCode;

  /**
   * 动态key
   */
  @ApiModelProperty(value = "动态key")
  private String dynamicKey;

  /**
   * 父级编码
   */
  @ApiModelProperty(value = "父级编码")
  private String parentCode;

  /**
   * 是否有效(Y/N)
   */
  @ApiModelProperty(value = "是否有效(Y/N)")
  private String isValid;

  /**
   * 是否执行(Y/N)
   */
  @ApiModelProperty(value= "是否执行(Y/N)")
  private String isExecute;
}
