package com.biz.crm.sfa.business.template.action.tpm.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * TPM活动执行陈列协议签署商品vo
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmExecuteVo", description = "TPM活动执行陈列协议签署商品vo")
public class ActionTpmProtocolProductVo extends UuidVo {

  private static final long serialVersionUID = 3827872416595449392L;

  /**
   * TPM活动执行协议ID
   */
  @ApiModelProperty("TPM活动执行协议ID")
  private String protocolId;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;
}
