package com.biz.crm.sfa.business.template.action.tpm.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * TPM活动执行信息查询dto
 *
 * @author ning.zhang
 * @date 2022/7/1
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmExecuteDto", description = "TPM活动执行信息查询dto")
public class ActionTpmExecuteDto extends TenantDto {

  /**
   * TPM活动编码
   */
  @ApiModelProperty(value = "TPM活动编码",  required = true)
  private String actionCode;

  /**
   * TPM活动明细编码
   */
  @ApiModelProperty(value = "TPM活动明细编码",  required = true)
  private String actionDetailCode;

  /**
   * TPM活动编码集合
   */
  @ApiModelProperty(value = "TPM活动编码集合", hidden = true)
  private Set<String> actionCodes;

  /**
   * TPM活动明细编码集合
   */
  @ApiModelProperty(value = "TPM活动明细编码集合", hidden = true)
  private Set<String> actionDetailCodes;

  /**
   * 用户账号
   */
  @ApiModelProperty(value = "用户账号", hidden = true)
  private String userAccount;

  /**
   * 动态key
   */
  @ApiModelProperty(value = "动态key")
  private String dynamicKey;

  /**
   * 父级编码
   */
  @ApiModelProperty(value = "父级编码")
  private String parentCode;

  /**
   * 终端编码
   */
  @ApiModelProperty(value = "终端编码",  required = true)
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;
}
