package com.biz.crm.sfa.business.template.action.tpm.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 陈列位置枚举
 *
 * @author ning.zhang
 * @date 2022/7/7
 */
@Getter
@AllArgsConstructor
public enum DisplayLocationType {

  /**
   * 活动订单
   */
  CASHIER_DESK("cashier_desk", "cashier_desk", "收银台旁", "1"),
  MIAN_CHANNEL("mian_channel", "mian_channel", "饮料主通道", "2"),
  DOOR("door", "door", "门口", "3"),
  OTHER("other", "other", "其它", "4"),;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static DisplayLocationType getByDictCode(String dictCode) {
    DisplayLocationType result = null;
    for (DisplayLocationType type : DisplayLocationType.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
