package com.biz.crm.sfa.business.template.action.tpm.sdk.register;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.action.tpm.sdk.vo.ActionTpmExecuteVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * TPM活动执行事件监听,通知上层服务基础事件触发
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
public interface ActionTpmExecuteRegister {

  /**
   * 注册器实现上层模块关联数据key
   *
   * @return 上层模块关联数据key
   */
  String relationKey();

  /**
   * 注册器实现上层模块关联数据名称
   *
   * @return 上层模块关联数据名称
   */
  String relationName();

  /**
   * 当创建TPM活动信息是触发该接口, 上层模块根据创建数据实现自身业务逻辑
   * ,并封装活动明细流水信息以供TPM处理资金使用信息
   *
   * @param vo 创建信息VO
   */
  void onCreate(ActionTpmExecuteVo vo);

  /**
   * 当触发上层模块关联数据查询时触发,上层模块实现此接口,返回与活动执行编码关联的数据映射(key:活动执行编码,value:活动执行编码关联的数据)
   *
   * @param executeCodes 活动执行编码集合
   * @return 活动执行编码关联的数据映射
   */
  Map<String,List<JSONObject>> onRequestByExecuteCodes(Set<String> executeCodes);
}
