package com.biz.crm.sfa.business.template.action.tpm.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesFieldsCollectTemplateFeginVo;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * TPM活动执行vo
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmExecuteVo", description = "TPM活动执行vo")
public class ActionTpmExecuteVo extends AbstractDynamicTemplateModel {

  private static final long serialVersionUID = -8994429571687569351L;

  /**
   * TPM活动编码
   */
  @ApiModelProperty("TPM活动编码")
  private String actionCode;

  /**
   * TPM活动明细编码
   */
  @ApiModelProperty("TPM活动明细编码")
  private String actionDetailCode;

  /**
   * TPM活动名称
   */
  @ApiModelProperty("TPM活动名称")
  private String actionName;

  /**
   * TPM活动描述
   */
  @ApiModelProperty("TPM活动描述")
  private String actionDescribe;

  /**
   * 活动执行编码
   */
  @ApiModelProperty("活动执行编码")
  private String executeCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  private String postName;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人组织编码")
  private String orgCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人组织名称")
  private String orgName;

  /**
   * TPM活动开始时间
   */
  @ApiModelProperty("TPM活动开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartDate;

  /**
   * TPM活动结束时间
   */
  @ApiModelProperty("TPM活动结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndDate;

  /**
   * 陈列协议
   */
  @ApiModelProperty("陈列协议")
  private List<ActionTpmProtocolVo> displayProtocols;

  /**
   * 关联上级模块数据映射(key:上层业务key,value:上层业务数据)
   */
  @ApiModelProperty("关联上级模块数据映射(key:上层业务key,value:上层业务数据)")
  private Map<String,List<JSONObject>> relationMap;

  /**
   * 活动明细流水信息
   */
  @ApiModelProperty("活动明细流水信息")
  private List<ActivitiesDetailSerialVo> activitiesDetailSerials;

  /**
   * 图片采集要求
   */
  @ApiModelProperty("图片采集要求")
  private List<ApprovalCollectVo> photoRequires;

  /**
   * 活动图片采集要求数据
   */
  @ApiModelProperty("活动图片采集要求数据")
  private List<ActivitiesDetailCollectVo> activitiesDetailCollects;

  /**
   * 活动字段采集模板数据
   */
  @ApiModelProperty("活动字段采集模板数据")
  private List<ActivitiesFieldsCollectTemplateFeginVo> fieldsCollectTemplates;

  /**
   * 活动字段采集模板结构
   */
  @ApiModelProperty("活动字段采集模板结构")
  private JSONObject fieldsCollectTemplateStruct;
}
