package com.biz.crm.sfa.business.template.action.tpm.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * TPM活动执行陈列协议签署条约数据vo
 *
 * @author ning.zhang
 * @date 2022/7/7
 */
@Data
@ApiModel(value = "ActionTpmProtocolTreatyVo", description = "TPM活动执行陈列协议签署条约数据vo")
public class ActionTpmProtocolTreatyVo implements Serializable {

  private static final long serialVersionUID = 2419806276624744428L;
  /**
   * 经销商名称
   */
  @ApiModelProperty("经销商名称")
  private String dealerName;

  /**
   * 活动编码
   */
  @ApiModelProperty("活动编码")
  private String activityCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddr;

  /**
   * 终端电话
   */
  @ApiModelProperty("终端电话")
  private String terminalPhone;

  /**
   * 陈列信息
   */
  @ApiModelProperty("陈列信息")
  private String displayInfo;

  /**
   * 陈列位置
   */
  @ApiModelProperty("陈列位置")
  private String displayPlace;

  /**
   * 陈列规格
   */
  @ApiModelProperty("陈列规格")
  private String displaySpecs;

  /**
   * 陈列件数
   */
  @ApiModelProperty("陈列件数")
  private String displayNumber;

  /**
   * 陈列开始时间
   */
  @ApiModelProperty("陈列开始时间")
  private String displayStartTime;

  /**
   * 陈列结束时间
   */
  @ApiModelProperty("陈列结束时间")
  private String displayEndTime;

  /**
   * 陈列月份
   */
  @ApiModelProperty("陈列月份")
  private String displayMonth;

  /**
   * 每月支付现金
   */
  @ApiModelProperty("每月支付现金")
  private BigDecimal monthPayAmount;

  /**
   * 合计奖励现金
   */
  @ApiModelProperty("合计奖励现金")
  private BigDecimal totalAmount;

  /**
   * 奖励收款人
   */
  @ApiModelProperty("奖励收款人")
  private String payee;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String contactPhone;

  /**
   * 当前操作人名称
   */
  @ApiModelProperty("当前操作人名称")
  private String currUserName;

  /**
   * 当前操作人电话
   */
  @ApiModelProperty("当前操作人电话")
  private String currUserPhone;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remarks;
}
