package com.biz.crm.sfa.business.template.action.tpm.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * TPM活动执行协议vo
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActionTpmProtocolVo", description = "TPM活动执行协议vo")
public class ActionTpmProtocolVo extends UuidVo {

  private static final long serialVersionUID = 5108823129758734313L;

  /**
   * TPM活动执行ID
   */
  @ApiModelProperty("TPM活动执行ID")
  private String executeId;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  /**
   * 陈列位置类型
   */
  @ApiModelProperty("陈列位置类型")
  private String locationType;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 陈列规格
   */
  @ApiModelProperty("陈列规格")
  private String displaySpecification;

  /**
   * 陈列件数
   */
  @ApiModelProperty("陈列件数")
  private BigDecimal displayNumber;

  /**
   * 陈列开始日期(yyyy-MM-dd)
   */
  @ApiModelProperty("陈列开始日期(yyyy-MM-dd)")
  private String displayStartDate;

  /**
   * 陈列结束日期(yyyy-MM-dd)
   */
  @ApiModelProperty("陈列结束日期(yyyy-MM-dd)")
  private String displayEndDate;

  /**
   * 陈列月份
   */
  @ApiModelProperty("陈列月份")
  private BigDecimal displayMoth;

  /**
   * 每月支付现金
   */
  @ApiModelProperty("每月支付现金")
  private BigDecimal mothPayAmount;

  /**
   * 合计奖励现金
   */
  @ApiModelProperty("合计奖励现金")
  private BigDecimal totalRewardAmount;

  /**
   * 奖励收款人
   */
  @ApiModelProperty("奖励收款人")
  private String rewardPayee;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  private String contactPhone;

  /**
   * 签名文件编码
   */
  @ApiModelProperty("签名文件编码")
  private String signFileCode;

  /**
   * 协议签署pdf文件编码
   */
  @ApiModelProperty("协议签署pdf文件编码")
  private String pdfFileCode;

  /**
   * 协议签署pdf文件名称
   */
  @ApiModelProperty("协议签署pdf文件名称")
  private String pdfName;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  private String superiorCustomerCode;

  /**
   * 上级客户名称
   */
  @ApiModelProperty("上级客户名称")
  private String superiorCustomerName;

  /**
   * 商品信息
   */
  @ApiModelProperty("商品信息")
  private List<ActionTpmProtocolProductVo> products;
}
