package com.biz.crm.sfa.business.template.action.tpm.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * TPM活动信息vo
 *
 * @author ning.zhang
 * @date 2022/7/4
 */
@Data
@ApiModel(value = "ActionTpmVo", description = "TPM活动信息vo")
public class ActionTpmVo implements Serializable {

  private static final long serialVersionUID = 3066256817926647317L;

  /**
   * TPM活动编码
   */
  @ApiModelProperty("TPM活动编码")
  private String actionCode;

  /**
   * TPM活动明细编码
   */
  @ApiModelProperty("TPM活动明细编码")
  private String actionDetailCode;

  /**
   * TPM活动名称
   */
  @ApiModelProperty("TPM活动名称")
  private String actionName;

  /**
   * TPM活动描述
   */
  @ApiModelProperty("TPM活动描述")
  private String actionDescribe;

  /**
   * 活动总金额
   */
  @ApiModelProperty("活动总金额")
  private BigDecimal totalAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("已使用金额")
  private BigDecimal usedAmount;

  /**
   * 已使用金额
   */
  @ApiModelProperty("本店已使用金额")
  private BigDecimal storeUsedAmount;


  /**
   * 支付方式
   */
  @ApiModelProperty("支付方式")
  private String payType;

  /**
   * 支付方式名称
   */
  @ApiModelProperty("支付方式名称")
  private String payTypeName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty("活动开始时间")
  @JsonFormat(locale = "zh",timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionStartTime;

  /**
   * 活动结束时间
   */
  @ApiModelProperty("活动结束时间")
  @JsonFormat(locale = "zh",timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date actionEndTime;

  /**
   * 是否已有执行信息(Y:是,N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否已有执行信息(Y:是,N:否)")
  private String haveExecute;
}
