package com.biz.crm.sfa.business.template.competing.goods.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.competing.goods.local.service.GoodsCollectModelService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 竞品采集表(GoodsCollectModel)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@RestController
@RequestMapping("/v1/competingGoods/goodsCollectModel")
@Slf4j
@Api(tags = "竞品表单：GoodsCollectModel：竞品采集model")
public class GoodsCollectModelController {
  /**
   * 服务对象
   */
  @Autowired
  private GoodsCollectModelService goodsCollectModelService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<GoodsCollectModel>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "竞品采集表") CompetingGoodsCollectPageDto dto) {
    try {
      Page<GoodsCollectModel> page = this.goodsCollectModelService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询对象包含关联信息
   *
   * @param id 分页对象
   * @return 查询对象包含关联信息
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findDetailsById")
  public Result<GoodsCollectModel> findDetailsById(@ApiParam(name = "id", value = "主键id") @RequestParam("id") String id) {
    try {
      GoodsCollectModel goodsCollectModel = this.goodsCollectModelService.findDetailsById(id);
      return Result.ok(goodsCollectModel);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
