package com.biz.crm.sfa.business.template.competing.goods.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 竞品商品表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoods", description = "竞品商品表")
@Entity
@TableName("sfa_competing_goods")
@Table(name = "sfa_competing_goods", indexes = {
    @Index(name = "sfa_competing_goods_index1", columnList = "tenant_code,business_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_competing_goods", comment = "竞品商品表")
public class CompetingGoods extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 竞品业务编码
   */
  @ApiModelProperty("竞品业务编码")
  @Column(name = "business_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '竞品业务编码'")
  private String businessCode;

  /**
   * 竞品名称
   */
  @ApiModelProperty("竞品名称")
  @Column(name = "goods_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '竞品名称'")
  private String goodsName;

  /**
   * 所属品牌
   */
  @ApiModelProperty("所属品牌")
  @Column(name = "goods_brand", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '所属品牌'")
  private String goodsBrand;
  /**
   * 所属系列
   */
  @ApiModelProperty("所属系列")
  @Column(name = "goods_serial", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '所属系列'")
  private String goodsSerial;


}
