package com.biz.crm.sfa.business.template.competing.goods.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 竞品采集表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompetingGoodsCollect", description = "竞品采集表")
@Entity
@TableName("sfa_competing_goods_collect")
@Table(name = "sfa_competing_goods_collect", indexes = {
    @Index(name = "sfa_competing_goods_collect_index1", columnList = "tenant_code,collect_code", unique = true),
    @Index(name = "sfa_competing_goods_collect_index2", columnList = "parent_code"),
    @Index(name = "sfa_competing_goods_collect_index3", columnList = "dynamic_key"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_competing_goods_collect", comment = "竞品采集表")
public class CompetingGoodsCollect extends AbstractDynamicTemplateEntity {

  private static final long serialVersionUID = -2765289943786899179L;

  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  @Column(name = "collect_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '采集编码'")
  private String collectCode;

  /**
   * 活动信息
   */
  @ApiModelProperty("活动信息")
  @Column(name = "action_info", length = 200, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '活动信息'")
  private String actionInfo;

  /**
   * 客户编码
   */
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '客户编码'")
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  @Column(name = "post_code", length = 64, columnDefinition = "varchar(64) COMMENT '提交人职位编码'")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  @Column(name = "post_name", length = 255, columnDefinition = "varchar(255) COMMENT '提交人职位名称'")
  private String postName;

  /**
   * 客户名称
   */
  @Column(name = "client_name", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '客户名称'")
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类别
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @Column(name = "client_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '客户类别(经销商/终端)'")
  @ApiModelProperty("客户类别(经销商/终端)")
  private String clientType;

  /**
   * 位置信息：经度
   */
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  @ApiModelProperty("位置信息:经度")
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  @ApiModelProperty("位置信息:纬度")
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @Column(name = "collect_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '位置信息'")
  @ApiModelProperty("位置信息")
  private String collectAddress;

  /**
   * 图片集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("图片集合")
  private List<CompetingGoodsCollectPicture> pictures;

  /**
   * 竞品清单集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("竞品清单集合")
  private List<CompetingGoodsCollectInventory> inventories;

}
