package com.biz.crm.sfa.business.template.competing.goods.local.model;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.field.validate.NotNullValidateStrategy;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleNotShowWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleSkipWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleTextAreaWidget;
import com.biz.crm.sfa.business.template.sdk.widget.SimpleUploadWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 竞品采集表单model
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GoodsCollectModel", description = "竞品采集表单model")
public class GoodsCollectModel extends AbstractDynamicTemplateModel {

  private static final long serialVersionUID = -2765289943786899179L;
  /**
   * 主键id
   */
  @ApiModelProperty("主键id")
  @DynamicField(fieldName = "主键id", required = false, controllKey = SimpleNotShowWidget.class)
  private String id;

  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  private String collectCode;

  /**
   * 提交人职位编码
   */
  @ApiModelProperty("提交人职位编码")
  private String postCode;

  /**
   * 提交人职位名称
   */
  @ApiModelProperty("提交人职位名称")
  private String postName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @DynamicField(fieldName = "客户编码", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @DynamicField(fieldName = "客户名称", required = false, controllKey = SimpleNotShowWidget.class)
  private String clientName;

  /**
   * 客户类别
   *
   * @see ClientTypeEnum#getDictCode()
   */
  @ApiModelProperty("客户类别(经销商/终端)")
  @DynamicField(fieldName = "客户类别", required = false, validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleNotShowWidget.class)
  private String clientType;

  /**
   * 位置信息：经度
   */
  @ApiModelProperty("位置信息:经度")
  @DynamicField(fieldName = "经度", required = false, controllKey = SimpleNotShowWidget.class)
  private BigDecimal longitude;

  /**
   * 位置信息：纬度
   */
  @ApiModelProperty("位置信息:纬度")
  @DynamicField(fieldName = "纬度", required = false, controllKey = SimpleNotShowWidget.class)
  private BigDecimal latitude;

  /**
   * 位置信息
   */
  @ApiModelProperty("位置信息")
  @DynamicField(fieldName = "位置信息", required = false, controllKey = SimpleNotShowWidget.class)
  private String collectAddress;

  /**
   * 品牌逗号拼接的集合
   */
  @ApiModelProperty("品牌逗号拼接的集合")
  private String goodsBrandStr;

  /**
   * 竞品采集
   */
  @ApiModelProperty("竞品采集")
  @DynamicField(fieldName = "竞品采集", validates = {@Validate(value = NotNullValidateStrategy.class)}, controllKey = SimpleSkipWidget.class)
  private List<GoodsCollectInventoryModel> inventories;

  /**
   * 活动信息
   */
  @ApiModelProperty("活动信息")
  @DynamicField(fieldName = "活动信息", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleTextAreaWidget.class)
  private String actionInfo;

  /**
   * 采集图片
   */
  @ApiModelProperty("采集图片")
  @DynamicField(fieldName = "采集图片", validates = {@Validate(value = NotNullValidateStrategy.class)}, controllKey = SimpleUploadWidget.class)
  private List<GoodsCollectPictureModel> pictures;


}
