package com.biz.crm.sfa.business.template.competing.goods.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.mapper.CompetingGoodsCollectMapper;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 竞品采集表(CompetingGoodsCollect)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@Component
public class CompetingGoodsCollectRepository extends ServiceImpl<CompetingGoodsCollectMapper, CompetingGoodsCollect> {

  @Autowired
  private CompetingGoodsCollectMapper competingGoodsCollectMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<CompetingGoodsCollect> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto) {
    Page<CompetingGoodsCollect> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CompetingGoodsCollect> pageList = this.competingGoodsCollectMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据parentCode和动态key查询数据
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  public CompetingGoodsCollect findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    return this.lambdaQuery().eq(CompetingGoodsCollect::getParentCode, parentCode)
        .eq(CompetingGoodsCollect::getDynamicKey, dynamicKey)
        .one();
  }
}

