package com.biz.crm.sfa.business.template.competing.goods.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 竞品采集表(CompetingGoodsCollect)表服务接口
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
public interface CompetingGoodsCollectService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  Page<CompetingGoodsCollect> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto);

  /**
   * 新增数据
   *
   * @param competingGoodsCollect 实体对象
   * @return 新增结果
   */
  CompetingGoodsCollect create(CompetingGoodsCollect competingGoodsCollect);

  /**
   * 修改新据
   *
   * @param competingGoodsCollect 实体对象
   * @return 修改结果
   */
  CompetingGoodsCollect update(CompetingGoodsCollect competingGoodsCollect);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

}

