package com.biz.crm.sfa.business.template.competing.goods.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import org.springframework.data.domain.Pageable;

/**
 * 竞品采集表(GoodsCollectModel)表服务接口
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
public interface GoodsCollectModelService {

  /**
   * 通过父级编码和动态key查询数据
   *
   * @param parentCode
   * @param dynamicKey
   * @return
   */
  GoodsCollectModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey);

  /**
   * 分页查询数据
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<GoodsCollectModel> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto);

  /**
   * 查询对象包含关联信息
   *
   * @param id 分页对象
   * @return 查询对象包含关联信息
   */
  GoodsCollectModel findDetailsById(String id);
}

