package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;


import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectInventory;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectInventoryRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectInventoryService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 竞品采集清单表(CompetingGoodsCollectInventory)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@Service("competingGoodsCollectInventoryService")
public class CompetingGoodsCollectInventoryServiceImpl implements CompetingGoodsCollectInventoryService {

  @Autowired
  private CompetingGoodsCollectInventoryRepository competingGoodsCollectInventoryRepository;

  @Transactional
  @Override
  public void createBatch(List<CompetingGoodsCollectInventory> inventories) {
    Validate.isTrue(!CollectionUtils.isEmpty(inventories), "新增数据时，采集商品集合不能为空！");
    inventories.forEach(this::createValidate);
    this.competingGoodsCollectInventoryRepository.saveBatch(inventories);
  }

  @Transactional
  @Override
  public void deleteByCollectCode(String collectCode) {
    this.competingGoodsCollectInventoryRepository.deleteByCollectCode(collectCode);
  }

  /**
   * 创建验证
   *
   * @param competingGoodsCollectInventory
   */
  private void createValidate(CompetingGoodsCollectInventory competingGoodsCollectInventory) {
    Validate.notNull(competingGoodsCollectInventory, "新增时，对象信息不能为空！");
    competingGoodsCollectInventory.setId(null);
    Validate.notBlank(competingGoodsCollectInventory.getCollectCode(), "新增数据时，采集编码不能为空！");
    Validate.notBlank(competingGoodsCollectInventory.getGoodsId(), "新增数据时，竞品id不能为空！");
    Validate.notNull(competingGoodsCollectInventory.getGoodsQuantity(), "新增数据时，铺货数量不能为空！");

  }

}

