package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;


import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectPictureRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectPictureService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 竞品采集图片表(CompetingGoodsCollectPicture)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-16 19:45:39
 */
@Service("competingGoodsCollectPictureService")
public class CompetingGoodsCollectPictureServiceImpl implements CompetingGoodsCollectPictureService {

  @Autowired
  private CompetingGoodsCollectPictureRepository competingGoodsCollectPictureRepository;

  @Transactional
  @Override
  public void createBatch(List<CompetingGoodsCollectPicture> pictures) {
    Validate.isTrue(!CollectionUtils.isEmpty(pictures), "新增数据时，采集图片集合不能为空！");
    pictures.forEach(this::createValidate);
    this.competingGoodsCollectPictureRepository.saveBatch(pictures);
  }

  @Transactional
  @Override
  public void deleteByCollectCode(String collectCode) {
    this.competingGoodsCollectPictureRepository.deleteByCollectCode(collectCode);
  }

  /**
   * 创建验证
   *
   * @param competingGoodsCollectPicture
   */
  private void createValidate(CompetingGoodsCollectPicture competingGoodsCollectPicture) {
    Validate.notNull(competingGoodsCollectPicture, "新增时，对象信息不能为空！");
    competingGoodsCollectPicture.setId(null);
    Validate.notBlank(competingGoodsCollectPicture.getCollectCode(), "新增数据时，采集编码不能为空！");
    Validate.notBlank(competingGoodsCollectPicture.getPictureUrl(), "新增数据时，图片路径不能为空！");

  }

}

