package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoods;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.constant.CompetingGoodsConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 竞品商品表(CompetingGoods)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@Service("competingGoodsService")
public class CompetingGoodsServiceImpl implements CompetingGoodsService {

  @Autowired
  private CompetingGoodsRepository competingGoodsRepository;

  @Autowired
  private GenerateCodeService generateCodeService;

  /**
   * 分页查询数据
   *
   * @param pageable       分页对象
   * @param competingGoods 实体对象
   * @return
   */
  @Override
  public Page<CompetingGoods> findByConditions(Pageable pageable, CompetingGoods competingGoods) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(competingGoods)) {
      competingGoods = new CompetingGoods();
    }
    competingGoods.setTenantCode(TenantUtils.getTenantCode());
    return this.competingGoodsRepository.findByConditions(pageable, competingGoods);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public CompetingGoods findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.competingGoodsRepository.getById(id);
  }

  /**
   * 新增数据
   *
   * @param competingGoods 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public CompetingGoods create(CompetingGoods competingGoods) {
    this.createValidate(competingGoods);
    this.competingGoodsRepository.saveOrUpdate(competingGoods);
    return competingGoods;
  }

  /**
   * 修改新据
   *
   * @param competingGoods 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public CompetingGoods update(CompetingGoods competingGoods) {
    Validate.notNull(competingGoods, "修改时，对象信息不能为空！");
    Validate.notBlank(competingGoods.getId(), "修改数据时，主键不能为空！");
    CompetingGoods goods = this.competingGoodsRepository.getById(competingGoods.getId());
    Validate.notNull(goods, "修改数据时，未查询到要修改的数据！");
    BeanUtils.copyProperties(competingGoods, goods, "id", "businessCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName");
    this.updateValidate(goods);
    this.competingGoodsRepository.saveOrUpdate(goods);
    return goods;
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.competingGoodsRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
  }

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @Transactional
  @Override
  public void enable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    this.competingGoodsRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @Transactional
  @Override
  public void disable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
    this.competingGoodsRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
  }

  /**
   * 创建验证
   *
   * @param competingGoods
   */
  private void createValidate(CompetingGoods competingGoods) {
    Validate.notNull(competingGoods, "新增时，对象信息不能为空！");
    competingGoods.setId(null);
    competingGoods.setTenantCode(TenantUtils.getTenantCode());
    competingGoods.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    competingGoods.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    competingGoods.setBusinessCode(this.generateCodeService.generateCode(CompetingGoodsConstant.COMPETING_GOODS_BUSINESS_CODE, 1).get(0));
    Validate.notBlank(competingGoods.getBusinessCode(), "新增数据时，业务编码不能为空！");
    Validate.notBlank(competingGoods.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(competingGoods.getGoodsBrand(), "新增数据时，所属品牌不能为空！");
    Validate.notBlank(competingGoods.getGoodsName(), "新增数据时，竞品名称不能为空！");
    Validate.notBlank(competingGoods.getGoodsSerial(), "新增数据时，所属系列不能为空！");

  }

  /**
   * 修改验证
   *
   * @param competingGoods
   */
  private void updateValidate(CompetingGoods competingGoods) {
    Validate.notBlank(competingGoods.getBusinessCode(), "修改数据时，业务编码不能为空！");
    Validate.notBlank(competingGoods.getTenantCode(), "修改数据时，租户编号不能为空！");
    Validate.notBlank(competingGoods.getGoodsBrand(), "修改数据时，所属品牌不能为空！");
    Validate.notBlank(competingGoods.getGoodsName(), "修改数据时，竞品名称不能为空！");
    Validate.notBlank(competingGoods.getGoodsSerial(), "修改数据时，所属系列不能为空！");

  }
}

