package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectInventoryModel;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectPictureModel;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectPictureRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.GoodsCollectInventoryModelRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.GoodsCollectModelService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 竞品采集表(GoodsCollectModel)表服务接口
 *
 * @author songjingen
 * @date 2022/6/18
 */
@Service
public class GoodsCollectModelServiceImpl implements GoodsCollectModelService {

  @Autowired
  private CompetingGoodsCollectRepository goodsCollectRepository;
  @Autowired
  private CompetingGoodsCollectPictureRepository competingGoodsCollectPictureRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private GoodsCollectInventoryModelRepository goodsCollectInventoryModelRepository;

  @Override
  public GoodsCollectModel findByParentCodeAndDynamicKey(String parentCode, String dynamicKey) {
    if (StringUtils.isAnyBlank(parentCode, dynamicKey)) {
      return null;
    }
    CompetingGoodsCollect competingGoodsCollect = this.goodsCollectRepository.findByParentCodeAndDynamicKey(parentCode, dynamicKey);
    if (competingGoodsCollect == null) {
      return null;
    }
    GoodsCollectModel goodsCollectModel = this.nebulaToolkitService.copyObjectByWhiteList(competingGoodsCollect, GoodsCollectModel.class, HashSet.class, ArrayList.class);
    //查询关联信息
    this.buildGoodsCollectModel(goodsCollectModel);
    return goodsCollectModel;
  }

  @Override
  public Page<GoodsCollectModel> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new CompetingGoodsCollectPageDto();
    }
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setCreateAccount(loginDetails.getAccount());
    Page<CompetingGoodsCollect> byConditions = this.goodsCollectRepository.findByConditions(pageable, dto);
    List<CompetingGoodsCollect> records = byConditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    //查询关联的信息
    Set<String> collectCodes = records.stream().map(CompetingGoodsCollect::getCollectCode).collect(Collectors.toSet());
    List<GoodsCollectInventoryModel> goodsCollectInventoryModels = this.goodsCollectInventoryModelRepository.findByCollectCodes(collectCodes);
    Map<String, List<GoodsCollectInventoryModel>> inventoryModelMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(goodsCollectInventoryModels)) {
      inventoryModelMap = goodsCollectInventoryModels.stream().collect(Collectors.groupingBy(GoodsCollectInventoryModel::getCollectCode));
    }
    //组装数据
    List<GoodsCollectModel> goodsCollectModels = (List<GoodsCollectModel>) this.nebulaToolkitService.copyCollectionByWhiteList(records, CompetingGoodsCollect.class, GoodsCollectModel.class, HashSet.class, ArrayList.class);
    for (GoodsCollectModel goodsCollectModel : goodsCollectModels) {
      List<GoodsCollectInventoryModel> inventoryModels = inventoryModelMap.get(goodsCollectModel.getCollectCode());
      if (!CollectionUtils.isEmpty(inventoryModels)) {
        String band = inventoryModels.stream().map(GoodsCollectInventoryModel::getGoodsBrand).collect(Collectors.joining(","));
        goodsCollectModel.setGoodsBrandStr(band);
      }
    }
    Page<GoodsCollectModel> modelPage = new Page<>();
    BeanUtils.copyProperties(byConditions, modelPage);
    modelPage.setRecords(goodsCollectModels);
    return modelPage;
  }

  @Override
  public GoodsCollectModel findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    CompetingGoodsCollect competingGoodsCollect = this.goodsCollectRepository.getById(id);
    if (competingGoodsCollect == null) {
      return null;
    }
    GoodsCollectModel goodsCollectModel = this.nebulaToolkitService.copyObjectByWhiteList(competingGoodsCollect, GoodsCollectModel.class, HashSet.class, ArrayList.class);
    //查询关联信息
    this.buildGoodsCollectModel(goodsCollectModel);
    return goodsCollectModel;
  }

  private void buildGoodsCollectModel(GoodsCollectModel goodsCollectModel) {
    String collectCode = goodsCollectModel.getCollectCode();
    //查询采集图片表信息
    List<CompetingGoodsCollectPicture> competingGoodsCollectPictures = this.competingGoodsCollectPictureRepository.findByCollectCode(collectCode);
    if (!CollectionUtils.isEmpty(competingGoodsCollectPictures)) {
      List<GoodsCollectPictureModel> goodsCollectPictureModels = (List<GoodsCollectPictureModel>) this.nebulaToolkitService.copyCollectionByWhiteList(competingGoodsCollectPictures, CompetingGoodsCollectPicture.class, GoodsCollectPictureModel.class, HashSet.class, ArrayList.class);
      goodsCollectModel.setPictures(goodsCollectPictureModels);
    }
    List<GoodsCollectInventoryModel> goodsCollectInventoryModels = this.goodsCollectInventoryModelRepository.findByCollectCodes(Sets.newHashSet(collectCode));
    goodsCollectModel.setInventories(goodsCollectInventoryModels);
  }
}
