package com.biz.crm.sfa.business.template.competing.goods.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.template.competing.goods.local.model.GoodsCollectModel;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.strategy.DynamicTemplateOperationStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 竞品采集表单模板操作策略实现类
 *
 * @author songjingen
 * @date 2022/6/22
 */
@Component
public class DynamicTemplateOperationStrategyForGoodsCollectModel implements DynamicTemplateOperationStrategy {

  @Autowired
  private DynamicFormOperationStrategyForGoodsCollectModel dynamicFormOperationStrategyForGoodsCollectModel;

  @Override
  public String dynamicFormCode() {
    return this.dynamicFormOperationStrategyForGoodsCollectModel.dynamicFormCode();
  }

  @Override
  public void onDynamicTemplateCreate(JSONObject jsonObject, String dynamicKey, String parentCode) {
    GoodsCollectModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), GoodsCollectModel.class);
    this.dynamicFormOperationStrategyForGoodsCollectModel.onDynamicFormCreate(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public void onDynamicTemplateModify(JSONObject jsonObject, String dynamicKey, String parentCode) {
    GoodsCollectModel goodsCollectModel = JsonUtils.json2Obj(jsonObject.toJSONString(), GoodsCollectModel.class);
    this.dynamicFormOperationStrategyForGoodsCollectModel.onDynamicFormModify(goodsCollectModel, dynamicKey, parentCode, null);
  }

  @Override
  public AbstractDynamicTemplateModel findByParentCode(String dynamicKey, String parentCode) {
    return this.dynamicFormOperationStrategyForGoodsCollectModel.findByParentCode(dynamicKey, parentCode);
  }
}
