/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.template.competing.goods.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectInventory;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollectPicture;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsCollectRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.repository.CompetingGoodsRepository;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectInventoryService;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectPictureService;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="competingGoodsCollectService")
public class CompetingGoodsCollectServiceImpl
implements CompetingGoodsCollectService {
    @Autowired
    private CompetingGoodsCollectRepository competingGoodsCollectRepository;
    @Autowired
    private CompetingGoodsCollectPictureService goodsCollectPictureService;
    @Autowired
    private CompetingGoodsCollectInventoryService goodsCollectInventoryService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private CompetingGoodsRepository competingGoodsRepository;

    @Override
    public Page<CompetingGoodsCollect> findByConditions(Pageable pageable, CompetingGoodsCollectPageDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CompetingGoodsCollectPageDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CompetingGoodsCollect> byConditions = this.competingGoodsCollectRepository.findByConditions(pageable, dto);
        return byConditions;
    }

    @Override
    @Transactional
    public CompetingGoodsCollect create(CompetingGoodsCollect competingGoodsCollect) {
        this.createValidate(competingGoodsCollect);
        List<CompetingGoodsCollectInventory> inventories = competingGoodsCollect.getInventories();
        List<CompetingGoodsCollectPicture> pictures = competingGoodsCollect.getPictures();
        Validate.isTrue((!CollectionUtils.isEmpty(inventories) ? 1 : 0) != 0, (String)"\u91c7\u96c6\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(pictures) ? 1 : 0) != 0, (String)"\u91c7\u96c6\u4fe1\u606f\u65f6\uff0c\u91c7\u96c6\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.competingGoodsCollectRepository.saveOrUpdate((Object)competingGoodsCollect);
        inventories.stream().forEach(competingGoodsCollectInventory -> competingGoodsCollectInventory.setCollectCode(competingGoodsCollect.getCollectCode()));
        pictures.stream().forEach(competingGoodsCollectPicture -> competingGoodsCollectPicture.setCollectCode(competingGoodsCollect.getCollectCode()));
        this.goodsCollectInventoryService.createBatch(inventories);
        this.goodsCollectPictureService.createBatch(pictures);
        return competingGoodsCollect;
    }

    @Override
    @Transactional
    public CompetingGoodsCollect update(CompetingGoodsCollect competingGoodsCollect) {
        Validate.notNull((Object)((Object)competingGoodsCollect), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CompetingGoodsCollectInventory> inventories = competingGoodsCollect.getInventories();
        List<CompetingGoodsCollectPicture> pictures = competingGoodsCollect.getPictures();
        Validate.isTrue((!CollectionUtils.isEmpty(inventories) ? 1 : 0) != 0, (String)"\u91c7\u96c6\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(pictures) ? 1 : 0) != 0, (String)"\u91c7\u96c6\u4fe1\u606f\u65f6\uff0c\u91c7\u96c6\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CompetingGoodsCollect goodsCollect = (CompetingGoodsCollect)((Object)this.competingGoodsCollectRepository.getById((Serializable)((Object)competingGoodsCollect.getId())));
        Validate.notNull((Object)((Object)goodsCollect), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u4fee\u6539\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)competingGoodsCollect), (Object)((Object)goodsCollect), (String[])new String[]{"id", "parentCode", "dynamicKey", "dynamicFormCode", "collectCode", "createTime", "tenantCode", "createAccount", "createName"});
        this.updateValidate(goodsCollect);
        this.competingGoodsCollectRepository.saveOrUpdate((Object)goodsCollect);
        String collectCode = goodsCollect.getCollectCode();
        inventories.stream().forEach(competingGoodsCollectInventory -> competingGoodsCollectInventory.setCollectCode(collectCode));
        pictures.stream().forEach(competingGoodsCollectPicture -> competingGoodsCollectPicture.setCollectCode(collectCode));
        this.goodsCollectInventoryService.deleteByCollectCode(collectCode);
        this.goodsCollectPictureService.deleteByCollectCode(collectCode);
        this.goodsCollectInventoryService.createBatch(inventories);
        this.goodsCollectPictureService.createBatch(pictures);
        return goodsCollect;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.competingGoodsCollectRepository.removeByIds(idList);
    }

    private void createValidate(CompetingGoodsCollect competingGoodsCollect) {
        Validate.notNull((Object)((Object)competingGoodsCollect), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        competingGoodsCollect.setId(null);
        competingGoodsCollect.setTenantCode(TenantUtils.getTenantCode());
        competingGoodsCollect.setCollectCode((String)this.generateCodeService.generateCode("CJ", 1).get(0));
        Validate.notBlank((CharSequence)competingGoodsCollect.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getActionInfo(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getCollectCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u91c7\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getClientCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CompetingGoodsCollect byParentCodeAndDynamicKey = this.competingGoodsCollectRepository.findByParentCodeAndDynamicKey(competingGoodsCollect.getParentCode(), competingGoodsCollect.getDynamicKey());
        Validate.isTrue((byParentCodeAndDynamicKey == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f53\u524d\u6267\u884c\u8ba1\u5212\u5df2\u63d0\u4ea4\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CompetingGoodsCollect competingGoodsCollect) {
        Validate.notBlank((CharSequence)competingGoodsCollect.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getActionInfo(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getCollectCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u91c7\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getClientCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)competingGoodsCollect.getClientType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

