package com.biz.crm.sfa.business.template.competing.goods.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.template.competing.goods.local.entity.CompetingGoodsCollect;
import com.biz.crm.sfa.business.template.competing.goods.local.service.CompetingGoodsCollectService;
import com.biz.crm.sfa.business.template.competing.goods.sdk.dto.CompetingGoodsCollectPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 竞品采集表(CompetingGoodsCollect)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-16 19:45:38
 */
@RestController
@RequestMapping("/v1/competingGoods/competingGoodsCollect")
@Slf4j
@Api(tags = "竞品表单：CompetingGoodsCollect：竞品采集表")
public class CompetingGoodsCollectController {
  /**
   * 服务对象
   */
  @Autowired
  private CompetingGoodsCollectService competingGoodsCollectService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CompetingGoodsCollect>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dto", value = "竞品采集表") CompetingGoodsCollectPageDto dto) {
    try {
      Page<CompetingGoodsCollect> page = this.competingGoodsCollectService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param competingGoodsCollect 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<CompetingGoodsCollect> create(@ApiParam(name = "competingGoodsCollect", value = "竞品采集表") @RequestBody CompetingGoodsCollect competingGoodsCollect) {
    try {
      CompetingGoodsCollect result = this.competingGoodsCollectService.create(competingGoodsCollect);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param competingGoodsCollect 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<CompetingGoodsCollect> update(@ApiParam(name = "competingGoodsCollect", value = "竞品采集表") @RequestBody CompetingGoodsCollect competingGoodsCollect) {
    try {
      CompetingGoodsCollect result = this.competingGoodsCollectService.update(competingGoodsCollect);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   * - 因为网关问题未修复好
   * - 为小程序不能发起patch请求
   *
   * @param competingGoodsCollect 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PostMapping("updateTurnPatch")
  public Result<CompetingGoodsCollect> updateTurnPatch(@ApiParam(name = "competingGoodsCollect", value = "竞品采集表") @RequestBody CompetingGoodsCollect competingGoodsCollect) {
    return this.update(competingGoodsCollect);
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.competingGoodsCollectService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
